/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.oauth;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Provider;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.provider.AlipayProvider;
import org.aoju.bus.oauth.provider.BaiduProvider;
import org.aoju.bus.oauth.provider.CodingProvider;
import org.aoju.bus.oauth.provider.CsdnProvider;
import org.aoju.bus.oauth.provider.DingTalkProvider;
import org.aoju.bus.oauth.provider.DouyinProvider;
import org.aoju.bus.oauth.provider.ElemeProvider;
import org.aoju.bus.oauth.provider.FacebookProvider;
import org.aoju.bus.oauth.provider.FeishuProvider;
import org.aoju.bus.oauth.provider.GiteeProvider;
import org.aoju.bus.oauth.provider.GithubProvider;
import org.aoju.bus.oauth.provider.GitlabProvider;
import org.aoju.bus.oauth.provider.GoogleProvider;
import org.aoju.bus.oauth.provider.HuaweiProvider;
import org.aoju.bus.oauth.provider.JdProvider;
import org.aoju.bus.oauth.provider.KujialeProvider;
import org.aoju.bus.oauth.provider.LinkedinProvider;
import org.aoju.bus.oauth.provider.MeituanProvider;
import org.aoju.bus.oauth.provider.MiProvider;
import org.aoju.bus.oauth.provider.MicrosoftProvider;
import org.aoju.bus.oauth.provider.OschinaProvider;
import org.aoju.bus.oauth.provider.PinterestProvider;
import org.aoju.bus.oauth.provider.QqProvider;
import org.aoju.bus.oauth.provider.RenrenProvider;
import org.aoju.bus.oauth.provider.StackOverflowProvider;
import org.aoju.bus.oauth.provider.TaobaoProvider;
import org.aoju.bus.oauth.provider.TeambitionProvider;
import org.aoju.bus.oauth.provider.TencentProvider;
import org.aoju.bus.oauth.provider.ToutiaoProvider;
import org.aoju.bus.oauth.provider.TwitterProvider;
import org.aoju.bus.oauth.provider.WeChatEEProvider;
import org.aoju.bus.oauth.provider.WeChatMpProvider;
import org.aoju.bus.oauth.provider.WeChatOPProvider;
import org.aoju.bus.oauth.provider.WeiboProvider;
import org.aoju.bus.starter.oauth.AuthProperties;

public class AuthProviderService {
    private static Map<Registry, Context> AUTH_CACHE = new ConcurrentHashMap<Registry, Context>();
    public final AuthProperties properties;

    public static void register(Registry type, Context context) {
        if (AUTH_CACHE.containsKey(type)) {
            throw new InstrumentException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u7ec4\u4ef6\uff1a" + type.name());
        }
        AUTH_CACHE.putIfAbsent(type, context);
    }

    public Provider require(Registry type) {
        Context context = AUTH_CACHE.get(type);
        if (ObjectUtils.isEmpty((Object)context)) {
            context = this.properties.getType().get(type);
        }
        if (Registry.ALIPAY.equals(type)) {
            return new AlipayProvider(context);
        }
        if (Registry.BAIDU.equals(type)) {
            return new BaiduProvider(context);
        }
        if (Registry.CODING.equals(type)) {
            return new CodingProvider(context);
        }
        if (Registry.CSDN.equals(type)) {
            return new CsdnProvider(context);
        }
        if (Registry.DINGTALK.equals(type)) {
            return new DingTalkProvider(context);
        }
        if (Registry.DOUYIN.equals(type)) {
            return new DouyinProvider(context);
        }
        if (Registry.ELEME.equals(type)) {
            return new ElemeProvider(context);
        }
        if (Registry.FACEBOOK.equals(type)) {
            return new FacebookProvider(context);
        }
        if (Registry.FEISHU.equals(type)) {
            return new FeishuProvider(context);
        }
        if (Registry.GITEE.equals(type)) {
            return new GiteeProvider(context);
        }
        if (Registry.GITHUB.equals(type)) {
            return new GithubProvider(context);
        }
        if (Registry.GITLAB.equals(type)) {
            return new GitlabProvider(context);
        }
        if (Registry.GOOGLE.equals(type)) {
            return new GoogleProvider(context);
        }
        if (Registry.HUAWEI.equals(type)) {
            return new HuaweiProvider(context);
        }
        if (Registry.JD.equals(type)) {
            return new JdProvider(context);
        }
        if (Registry.KUJIALE.equals(type)) {
            return new KujialeProvider(context);
        }
        if (Registry.LINKEDIN.equals(type)) {
            return new LinkedinProvider(context);
        }
        if (Registry.MEITUAN.equals(type)) {
            return new MeituanProvider(context);
        }
        if (Registry.MICROSOFT.equals(type)) {
            return new MicrosoftProvider(context);
        }
        if (Registry.MI.equals(type)) {
            return new MiProvider(context);
        }
        if (Registry.OSCHINA.equals(type)) {
            return new OschinaProvider(context);
        }
        if (Registry.PINTEREST.equals(type)) {
            return new PinterestProvider(context);
        }
        if (Registry.QQ.equals(type)) {
            return new QqProvider(context);
        }
        if (Registry.RENREN.equals(type)) {
            return new RenrenProvider(context);
        }
        if (Registry.STACKOVERFLOW.equals(type)) {
            return new StackOverflowProvider(context);
        }
        if (Registry.TAOBAO.equals(type)) {
            return new TaobaoProvider(context);
        }
        if (Registry.TEAMBITION.equals(type)) {
            return new TeambitionProvider(context);
        }
        if (Registry.TENCENT.equals(type)) {
            return new TencentProvider(context);
        }
        if (Registry.TOUTIAO.equals(type)) {
            return new ToutiaoProvider(context);
        }
        if (Registry.TWITTER.equals(type)) {
            return new TwitterProvider(context);
        }
        if (Registry.WECHAT_EE.equals(type)) {
            return new WeChatEEProvider(context);
        }
        if (Registry.WECHAT_MP.equals(type)) {
            return new WeChatMpProvider(context);
        }
        if (Registry.WECHAT_OP.equals(type)) {
            return new WeChatOPProvider(context);
        }
        if (Registry.WEIBO.equals(type)) {
            return new WeiboProvider(context);
        }
        throw new InstrumentException(Builder.ErrorCode.UNSUPPORTED.getMsg());
    }

    public AuthProviderService(AuthProperties properties) {
        this.properties = properties;
    }
}

