/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.apache.httpclient;

import java.util.ArrayList;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class TraceHttpResponseInterceptor
implements HttpResponseInterceptor {
    private final Backend backend;
    private final HttpHeaderTransport transportSerialization;
    private final String profile;

    public TraceHttpResponseInterceptor() {
        this("default");
    }

    public TraceHttpResponseInterceptor(String profile) {
        this(Builder.getBackend(), profile);
    }

    TraceHttpResponseInterceptor(Backend backend, String profile) {
        this.backend = backend;
        this.profile = profile;
        this.transportSerialization = new HttpHeaderTransport();
    }

    public final void process(HttpResponse response, HttpContext context) {
        TraceFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
        Header[] responseHeaders = response.getHeaders("TPIC");
        if (responseHeaders != null && responseHeaders.length > 0 && filterConfiguration.shouldProcessContext(TraceFilterConfiguration.Channel.IncomingResponse)) {
            ArrayList<String> stringTraceHeaders = new ArrayList<String>();
            for (Header header : responseHeaders) {
                stringTraceHeaders.add(header.getValue());
            }
            this.backend.putAll(filterConfiguration.filterDeniedParams(this.transportSerialization.parse(stringTraceHeaders), TraceFilterConfiguration.Channel.IncomingResponse));
        }
    }
}

