/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.swing.ClipboardListener;
import org.aoju.bus.core.swing.ClipboardMonitor;
import org.aoju.bus.core.swing.ImageSelection;
import org.aoju.bus.core.utils.ImageUtils;
import org.aoju.bus.core.utils.UriUtils;

public class SwingUtils {
    private static final Robot robot;
    public static Dimension dimension;
    private static int delay;

    public static int getWidth() {
        return (int)dimension.getWidth();
    }

    public static int getHeight() {
        return (int)dimension.getHeight();
    }

    public static Rectangle getRectangle() {
        return new Rectangle(SwingUtils.getWidth(), SwingUtils.getHeight());
    }

    public static void setDelay(int delayMillis) {
        delay = delayMillis;
    }

    public static void mouseMove(int x, int y) {
        robot.mouseMove(x, y);
    }

    public static void click() {
        robot.mousePress(16);
        robot.mouseRelease(16);
        SwingUtils.delay();
    }

    public static void rightClick() {
        robot.mousePress(16);
        robot.mouseRelease(16);
        SwingUtils.delay();
    }

    public static void mouseWheel(int wheelAmt) {
        robot.mouseWheel(wheelAmt);
        SwingUtils.delay();
    }

    public static void keyClick(int ... keyCodes) {
        for (int keyCode : keyCodes) {
            robot.keyPress(keyCode);
            robot.keyRelease(keyCode);
        }
        SwingUtils.delay();
    }

    public static void keyPressString(String str) {
        SwingUtils.setStr(str);
        SwingUtils.keyPressWithCtrl(86);
        SwingUtils.delay();
    }

    public static void keyPressWithShift(int key) {
        robot.keyPress(16);
        robot.keyPress(key);
        robot.keyRelease(key);
        robot.keyRelease(16);
        SwingUtils.delay();
    }

    public static void keyPressWithCtrl(int key) {
        robot.keyPress(17);
        robot.keyPress(key);
        robot.keyRelease(key);
        robot.keyRelease(17);
        SwingUtils.delay();
    }

    public static void keyPressWithAlt(int key) {
        robot.keyPress(18);
        robot.keyPress(key);
        robot.keyRelease(key);
        robot.keyRelease(18);
        SwingUtils.delay();
    }

    public static BufferedImage captureScreen() {
        return SwingUtils.captureScreen(SwingUtils.getRectangle());
    }

    public static File captureScreen(File outFile) {
        ImageUtils.write(SwingUtils.captureScreen(), outFile);
        return outFile;
    }

    public static BufferedImage captureScreen(Rectangle screenRect) {
        return robot.createScreenCapture(screenRect);
    }

    public static File captureScreen(Rectangle screenRect, File outFile) {
        ImageUtils.write(SwingUtils.captureScreen(screenRect), outFile);
        return outFile;
    }

    private static void delay() {
        if (delay > 0) {
            robot.delay(delay);
        }
    }

    public static Desktop getDsktop() {
        return Desktop.getDesktop();
    }

    public static void browse(String url) {
        SwingUtils.browse(UriUtils.toURI(url));
    }

    public static void browse(URI uri) {
        Desktop dsktop = SwingUtils.getDsktop();
        try {
            dsktop.browse(uri);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void open(File file) {
        Desktop dsktop = SwingUtils.getDsktop();
        try {
            dsktop.open(file);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void edit(File file) {
        Desktop dsktop = SwingUtils.getDsktop();
        try {
            dsktop.edit(file);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void print(File file) {
        Desktop dsktop = SwingUtils.getDsktop();
        try {
            dsktop.print(file);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void mail(String mailAddress) {
        Desktop dsktop = SwingUtils.getDsktop();
        try {
            dsktop.mail(UriUtils.toURI(mailAddress));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public static void set(Transferable contents) {
        SwingUtils.set(contents, null);
    }

    public static void set(Transferable contents, ClipboardOwner owner) {
        SwingUtils.getClipboard().setContents(contents, owner);
    }

    public static Object get(DataFlavor flavor) {
        return SwingUtils.get(SwingUtils.getClipboard().getContents(null), flavor);
    }

    public static Object get(Transferable content, DataFlavor flavor) {
        if (null != content && content.isDataFlavorSupported(flavor)) {
            try {
                return content.getTransferData(flavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                throw new InstrumentException(e);
            }
        }
        return null;
    }

    public static String getStr() {
        return (String)SwingUtils.get(DataFlavor.stringFlavor);
    }

    public static void setStr(String text) {
        SwingUtils.set(new StringSelection(text));
    }

    public static String getStr(Transferable content) {
        return (String)SwingUtils.get(content, DataFlavor.stringFlavor);
    }

    public static Image getImage() {
        return (Image)SwingUtils.get(DataFlavor.imageFlavor);
    }

    public static void setImage(Image image) {
        SwingUtils.set(new ImageSelection(image), null);
    }

    public static Image getImage(Transferable content) {
        return (Image)SwingUtils.get(content, DataFlavor.imageFlavor);
    }

    public static void listen(ClipboardListener listener) {
        SwingUtils.listen(listener, true);
    }

    public static void listen(ClipboardListener listener, boolean sync) {
        SwingUtils.listen(10, 100L, listener, sync);
    }

    public static void listen(int tryCount, long delay, ClipboardListener listener, boolean sync) {
        ClipboardMonitor.INSTANCE.setTryCount(tryCount).setDelay(delay).addListener(listener).listen(sync);
    }

    static {
        dimension = Toolkit.getDefaultToolkit().getScreenSize();
        try {
            robot = new Robot();
        }
        catch (AWTException e) {
            throw new InstrumentException(e);
        }
    }
}

