/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.provider;

import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.Provider;
import org.aoju.bus.crypto.symmetric.RC4;

public class RC4Provider
implements Provider {
    @Override
    public byte[] encrypt(String key, byte[] content) {
        if (StringUtils.isEmpty(key)) {
            throw new InstrumentException("key is null!");
        }
        RC4 rc4 = new RC4(key);
        return rc4.encrypt(StringUtils.toString(content, Charset.UTF_8));
    }

    @Override
    public byte[] decrypt(String key, byte[] content) {
        if (StringUtils.isEmpty(key)) {
            throw new InstrumentException("key is null!");
        }
        RC4 rc4 = new RC4(key);
        return rc4.decrypt(content).getBytes();
    }
}

