/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.extra.ftp.AbstractFtp;
import org.aoju.bus.extra.ftp.FtpConfig;
import org.aoju.bus.extra.ftp.FtpMode;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpUtils
extends AbstractFtp {
    public static final int DEFAULT_PORT = 21;
    private FTPClient client;
    private FtpMode mode;
    private boolean backToPwd;

    public FtpUtils(String host) {
        this(host, 21);
    }

    public FtpUtils(String host, int port) {
        this(host, port, "anonymous", "");
    }

    public FtpUtils(String host, int port, String user, String password) {
        this(host, port, user, password, Charset.UTF_8);
    }

    public FtpUtils(String host, int port, String user, String password, java.nio.charset.Charset charset) {
        this(host, port, user, password, charset, null);
    }

    public FtpUtils(String host, int port, String user, String password, java.nio.charset.Charset charset, FtpMode mode) {
        this(new FtpConfig(host, port, user, password, charset), mode);
    }

    public FtpUtils(FtpConfig config, FtpMode mode) {
        super(config);
        this.mode = mode;
        this.init();
    }

    public FtpUtils init() {
        return this.init(this.ftpConfig, this.mode);
    }

    public FtpUtils init(String host, int port, String user, String password) {
        return this.init(host, port, user, password, null);
    }

    public FtpUtils init(String host, int port, String user, String password, FtpMode mode) {
        return this.init(new FtpConfig(host, port, user, password, this.ftpConfig.getCharset()), mode);
    }

    public FtpUtils init(FtpConfig config, FtpMode mode) {
        FTPClient client = new FTPClient();
        client.setControlEncoding(config.getCharset().toString());
        client.setConnectTimeout((int)config.getConnectionTimeout());
        try {
            client.setSoTimeout((int)config.getSoTimeout());
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        try {
            client.connect(config.getHost(), config.getPort());
            client.login(config.getUser(), config.getPassword());
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        int replyCode = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            try {
                client.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new InstrumentException("Login failed for user [{}], reply code is: [{}]", config.getUser(), replyCode);
        }
        this.client = client;
        if (mode != null) {
            this.setMode(mode);
        }
        return this;
    }

    public FtpUtils setMode(FtpMode mode) {
        this.mode = mode;
        switch (mode) {
            case Active: {
                this.client.enterLocalActiveMode();
                break;
            }
            case Passive: {
                this.client.enterLocalPassiveMode();
            }
        }
        return this;
    }

    public FtpUtils setBackToPwd(boolean backToPwd) {
        this.backToPwd = backToPwd;
        return this;
    }

    @Override
    public FtpUtils reconnectIfTimeout() {
        String pwd = null;
        try {
            pwd = this.pwd();
        }
        catch (InstrumentException instrumentException) {
            // empty catch block
        }
        if (pwd == null) {
            return this.init();
        }
        return this;
    }

    @Override
    public boolean cd(String directory) {
        if (StringUtils.isBlank(directory)) {
            return false;
        }
        try {
            return this.client.changeWorkingDirectory(directory);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    @Override
    public String pwd() {
        try {
            return this.client.printWorkingDirectory();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    @Override
    public List<String> ls(String path) {
        FTPFile[] ftpFiles = this.lsFiles(path);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (FTPFile ftpFile : ftpFiles) {
            fileNames.add(ftpFile.getName());
        }
        return fileNames;
    }

    public FTPFile[] lsFiles(String path) {
        FTPFile[] ftpFiles;
        String pwd = null;
        if (StringUtils.isNotBlank(path)) {
            pwd = this.pwd();
            this.cd(path);
        }
        try {
            ftpFiles = this.client.listFiles();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            this.cd(pwd);
        }
        return ftpFiles;
    }

    @Override
    public boolean mkdir(String dir) {
        try {
            return this.client.makeDirectory(dir);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public boolean existFile(String path) {
        FTPFile[] ftpFileArr;
        try {
            ftpFileArr = this.client.listFiles(path);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return ArrayUtils.isNotEmpty(ftpFileArr);
    }

    @Override
    public boolean delFile(String path) {
        boolean isSuccess;
        String pwd = this.pwd();
        String fileName = FileUtils.getName(path);
        String dir = StringUtils.removeSuffix(path, fileName);
        this.cd(dir);
        try {
            isSuccess = this.client.deleteFile(fileName);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            this.cd(pwd);
        }
        return isSuccess;
    }

    @Override
    public boolean delDir(String dirPath) {
        FTPFile[] dirs;
        try {
            dirs = this.client.listFiles(dirPath);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        for (FTPFile ftpFile : dirs) {
            String name = ftpFile.getName();
            String childPath = StringUtils.format("{}/{}", dirPath, name);
            if (ftpFile.isDirectory()) {
                if (ObjectUtils.equal(name, ".") || ObjectUtils.equal(name, "..")) continue;
                this.delDir(childPath);
                continue;
            }
            this.delFile(childPath);
        }
        try {
            return this.client.removeDirectory(dirPath);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    @Override
    public boolean upload(String destPath, File file) {
        Assert.notNull(file, "file to upload is null !", new Object[0]);
        return this.upload(destPath, file.getName(), file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean upload(String path, String fileName, File file) {
        try (BufferedInputStream in = FileUtils.getInputStream(file);){
            boolean bl = this.upload(path, fileName, in);
            return bl;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public boolean upload(String path, String fileName, InputStream fileStream) {
        boolean isOk;
        try {
            this.client.setFileType(2);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        String pwd = null;
        if (this.backToPwd) {
            pwd = this.pwd();
        }
        if (StringUtils.isNotBlank(path)) {
            this.mkDirs(path);
            isOk = this.cd(path);
            if (!isOk) {
                return false;
            }
        }
        try {
            isOk = this.client.storeFile(fileName, fileStream);
            return isOk;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            if (this.backToPwd) {
                this.cd(pwd);
            }
        }
    }

    @Override
    public void download(String path, File outFile) {
        String fileName = FileUtils.getName(path);
        String dir = StringUtils.removeSuffix(path, fileName);
        this.download(dir, fileName, outFile);
    }

    public void download(String path, String fileName, File outFile) {
        if (outFile.isDirectory()) {
            outFile = new File(outFile, fileName);
        }
        if (!outFile.exists()) {
            FileUtils.touch(outFile);
        }
        try (BufferedOutputStream out = FileUtils.getOutputStream(outFile);){
            this.download(path, fileName, out);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public void download(String path, String fileName, OutputStream out) {
        String pwd = null;
        if (this.backToPwd) {
            pwd = this.pwd();
        }
        this.cd(path);
        try {
            this.client.setFileType(2);
            this.client.retrieveFile(fileName, out);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            if (this.backToPwd) {
                this.cd(pwd);
            }
        }
    }

    public FTPClient getClient() {
        return this.client;
    }

    @Override
    public void close() throws IOException {
        if (null != this.client) {
            this.client.logout();
            if (this.client.isConnected()) {
                this.client.disconnect();
            }
            this.client = null;
        }
    }
}

