/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.sms;

import com.alibaba.fastjson.JSON;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.extra.sms.AliSmsEntity;
import org.aoju.bus.extra.sms.AliSmsResult;

public class AliSmsService {
    private static final String ALIYUN_PRODUCT = "Dysmsapi";
    private static final String ALIYUN_PRODUCT_DOMAIN = "dysmsapi.aliyuncs.com";
    private static final String SUCCESS_RESULT = "OK";
    private String accessKey;
    private String accessSecret;
    private String signName;
    private String profile;
    private Integer connectionTimeout;
    private Integer readTimeout;

    public AliSmsResult send(AliSmsEntity entity) throws InstrumentException {
        try {
            DefaultProfile profile = DefaultProfile.getProfile((String)StringUtils.toString(this.profile, "default"), (String)this.accessKey, (String)this.accessSecret);
            DefaultProfile.addEndpoint((String)this.profile, (String)ALIYUN_PRODUCT, (String)ALIYUN_PRODUCT_DOMAIN);
            DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
            SendSmsRequest sendSmsRequest = new SendSmsRequest();
            sendSmsRequest.setReadTimeout(Integer.valueOf(this.readTimeout == null ? 10000 : this.readTimeout));
            sendSmsRequest.setConnectTimeout(Integer.valueOf(this.connectionTimeout == null ? 10000 : this.connectionTimeout));
            sendSmsRequest.setPhoneNumbers(entity.getPhone());
            sendSmsRequest.setSignName(this.signName);
            sendSmsRequest.setTemplateCode(entity.getTemplateCode());
            sendSmsRequest.setTemplateParam(JSON.toJSONString(entity.getParams()));
            SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)sendSmsRequest);
            return AliSmsResult.builder().success(SUCCESS_RESULT.equals(sendSmsResponse.getCode())).build();
        }
        catch (Exception e) {
            throw new InstrumentException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u53d1\u9001\u9001\u5f02\u5e38" + e.getMessage());
        }
    }

    public AliSmsService(String accessKey, String accessSecret, String signName, String profile, Integer connectionTimeout, Integer readTimeout) {
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
        this.signName = signName;
        this.profile = profile;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }
}

