/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab;

import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.aoju.bus.gitlab.AbstractApi;
import org.aoju.bus.gitlab.GitLabApi;
import org.aoju.bus.gitlab.GitLabApiException;
import org.aoju.bus.gitlab.GitLabApiForm;
import org.aoju.bus.gitlab.Pager;
import org.aoju.bus.gitlab.models.SystemHook;

public class SystemHooksApi
extends AbstractApi {
    public SystemHooksApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<SystemHook> getSystemHooks() throws GitLabApiException {
        return this.getSystemHooks(this.getDefaultPerPage()).all();
    }

    public List<SystemHook> getSystemHooks(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "hooks");
        return (List)response.readEntity((GenericType)new GenericType<List<SystemHook>>(){});
    }

    public Pager<SystemHook> getSystemHooks(int itemsPerPage) throws GitLabApiException {
        return new Pager<SystemHook>(this, SystemHook.class, itemsPerPage, null, "hooks");
    }

    public Stream<SystemHook> getSystemHookStream() throws GitLabApiException {
        return this.getSystemHooks(this.getDefaultPerPage()).stream();
    }

    public SystemHook addSystemHook(String url, String token, Boolean pushEvents, Boolean tagPushEvents, Boolean enablSsslVerification) throws GitLabApiException {
        if (url == null) {
            throw new RuntimeException("url cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("url", url, true).withParam("token", token).withParam("push_events", pushEvents).withParam("tag_push_events", tagPushEvents).withParam("enable_ssl_verification", enablSsslVerification);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"hooks"});
        return (SystemHook)response.readEntity(SystemHook.class);
    }

    public void deleteSystemHook(SystemHook hook) throws GitLabApiException {
        if (hook == null) {
            throw new RuntimeException("hook cannot be null");
        }
        this.deleteSystemHook(hook.getId());
    }

    public void deleteSystemHook(Integer hookId) throws GitLabApiException {
        if (hookId == null) {
            throw new RuntimeException("hookId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "hooks", hookId);
    }

    public void testSystemHook(SystemHook hook) throws GitLabApiException {
        if (hook == null) {
            throw new RuntimeException("hook cannot be null");
        }
        this.testSystemHook(hook.getId());
    }

    public void testSystemHook(Integer hookId) throws GitLabApiException {
        if (hookId == null) {
            throw new RuntimeException("hookId cannot be null");
        }
        this.get(Response.Status.OK, null, "hooks", hookId);
    }
}

