/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab.hooks;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import org.aoju.bus.gitlab.GitLabApiException;
import org.aoju.bus.gitlab.HookManager;
import org.aoju.bus.gitlab.hooks.BuildEvent;
import org.aoju.bus.gitlab.hooks.Event;
import org.aoju.bus.gitlab.hooks.IssueEvent;
import org.aoju.bus.gitlab.hooks.JobEvent;
import org.aoju.bus.gitlab.hooks.MergeRequestEvent;
import org.aoju.bus.gitlab.hooks.NoteEvent;
import org.aoju.bus.gitlab.hooks.PipelineEvent;
import org.aoju.bus.gitlab.hooks.PushEvent;
import org.aoju.bus.gitlab.hooks.TagPushEvent;
import org.aoju.bus.gitlab.hooks.WebHookListener;
import org.aoju.bus.gitlab.hooks.WikiPageEvent;
import org.aoju.bus.gitlab.utils.HttpRequestUtils;
import org.aoju.bus.gitlab.utils.JacksonJson;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.logger.level.Level;

public class WebHookManager
implements HookManager {
    private final JacksonJson jacksonJson = new JacksonJson();
    private final List<WebHookListener> webhookListeners = new CopyOnWriteArrayList<WebHookListener>();
    private String secretToken;

    public WebHookManager() {
    }

    public WebHookManager(String secretToken) {
        this.secretToken = secretToken;
    }

    @Override
    public String getSecretToken() {
        return this.secretToken;
    }

    @Override
    public void setSecretToken(String secretToken) {
        this.secretToken = secretToken;
    }

    @Override
    public void handleEvent(HttpServletRequest request) throws GitLabApiException {
        this.handleRequest(request);
    }

    public Event handleRequest(HttpServletRequest request) throws GitLabApiException {
        Event event;
        String eventName = request.getHeader("X-Gitlab-Event");
        if (eventName == null || eventName.trim().isEmpty()) {
            Logger.warn("X-Gitlab-Event header is missing!", new Object[0]);
            return null;
        }
        if (!this.isValidSecretToken(request)) {
            String message = "X-Gitlab-Token mismatch!";
            Logger.warn(message, new Object[0]);
            throw new GitLabApiException(message);
        }
        Logger.info("handleEvent: X-Gitlab-Event=" + eventName, new Object[0]);
        switch (eventName) {
            case "Issue Hook": 
            case "Job Hook": 
            case "Merge Request Hook": 
            case "Note Hook": 
            case "Pipeline Hook": 
            case "Push Hook": 
            case "Tag Push Hook": 
            case "Wiki Page Hook": {
                break;
            }
            default: {
                String message = "Unsupported X-Gitlab-Event, event Name=" + eventName;
                Logger.warn(message, new Object[0]);
                throw new GitLabApiException(message);
            }
        }
        try {
            if (Logger.get().isEnabled(Level.ALL)) {
                Logger.debug(HttpRequestUtils.getShortRequestDump(eventName + " webhook", true, request), new Object[0]);
                String postData = HttpRequestUtils.getPostDataAsString(request);
                Logger.debug("Raw POST data:\n" + postData, new Object[0]);
                event = this.jacksonJson.unmarshal(Event.class, postData);
                Logger.debug(event.getObjectKind() + " event:\n" + this.jacksonJson.marshal(event) + "\n", new Object[0]);
            } else {
                InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream());
                event = this.jacksonJson.unmarshal(Event.class, reader);
            }
        }
        catch (Exception e) {
            Logger.warn(String.format("Error processing JSON data, exception=%s, error=%s", e.getClass().getSimpleName(), e.getMessage()), new Object[0]);
            throw new GitLabApiException(e);
        }
        try {
            event.setRequestUrl(request.getRequestURL().toString());
            event.setRequestQueryString(request.getQueryString());
            String secretToken = request.getHeader("X-Gitlab-Token");
            event.setRequestSecretToken(secretToken);
            this.fireEvent(event);
            return event;
        }
        catch (Exception e) {
            Logger.warn(String.format("Error processing event, exception=%s, error=%s", e.getClass().getSimpleName(), e.getMessage()), new Object[0]);
            throw new GitLabApiException(e);
        }
    }

    public void handleEvent(Event event) throws GitLabApiException {
        Logger.info("handleEvent: object_kind=" + event.getObjectKind(), new Object[0]);
        switch (event.getObjectKind()) {
            case "build": 
            case "issue": 
            case "job": 
            case "merge_request": 
            case "note": 
            case "pipeline": 
            case "push": 
            case "tag_push": 
            case "wiki_page": {
                this.fireEvent(event);
                break;
            }
            default: {
                String message = "Unsupported event object_kind, object_kind=" + event.getObjectKind();
                Logger.warn(message, new Object[0]);
                throw new GitLabApiException(message);
            }
        }
    }

    public void addListener(WebHookListener listener) {
        if (!this.webhookListeners.contains(listener)) {
            this.webhookListeners.add(listener);
        }
    }

    public void removeListener(WebHookListener listener) {
        this.webhookListeners.remove(listener);
    }

    public void fireEvent(Event event) throws GitLabApiException {
        switch (event.getObjectKind()) {
            case "build": {
                this.fireBuildEvent((BuildEvent)event);
                break;
            }
            case "issue": {
                this.fireIssueEvent((IssueEvent)event);
                break;
            }
            case "job": {
                this.fireJobEvent((JobEvent)event);
                break;
            }
            case "merge_request": {
                this.fireMergeRequestEvent((MergeRequestEvent)event);
                break;
            }
            case "note": {
                this.fireNoteEvent((NoteEvent)event);
                break;
            }
            case "pipeline": {
                this.firePipelineEvent((PipelineEvent)event);
                break;
            }
            case "push": {
                this.firePushEvent((PushEvent)event);
                break;
            }
            case "tag_push": {
                this.fireTagPushEvent((TagPushEvent)event);
                break;
            }
            case "wiki_page": {
                this.fireWikiPageEvent((WikiPageEvent)event);
                break;
            }
            default: {
                String message = "Unsupported event object_kind, object_kind=" + event.getObjectKind();
                Logger.warn(message, new Object[0]);
                throw new GitLabApiException(message);
            }
        }
    }

    protected void fireBuildEvent(BuildEvent buildEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onBuildEvent(buildEvent);
        }
    }

    protected void fireIssueEvent(IssueEvent issueEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onIssueEvent(issueEvent);
        }
    }

    protected void fireJobEvent(JobEvent jobEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onJobEvent(jobEvent);
        }
    }

    protected void fireMergeRequestEvent(MergeRequestEvent mergeRequestEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onMergeRequestEvent(mergeRequestEvent);
        }
    }

    protected void fireNoteEvent(NoteEvent noteEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onNoteEvent(noteEvent);
        }
    }

    protected void firePipelineEvent(PipelineEvent pipelineEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onPipelineEvent(pipelineEvent);
        }
    }

    protected void firePushEvent(PushEvent pushEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onPushEvent(pushEvent);
        }
    }

    protected void fireTagPushEvent(TagPushEvent tagPushEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onTagPushEvent(tagPushEvent);
        }
    }

    protected void fireWikiPageEvent(WikiPageEvent wikiPageEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onWikiPageEvent(wikiPageEvent);
        }
    }
}

