/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.drivers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;

@ThreadSafe
public final class Disk {
    private static final String DISKUTIL_CS_LIST = "diskutil cs list";
    private static final String LOGICAL_VOLUME_FAMILY = "Logical Volume Family";
    private static final String LOGICAL_VOLUME_GROUP = "Logical Volume Group";

    private Disk() {
    }

    public static Map<String, String> queryLogicalVolumeMap() {
        HashMap<String, String> logicalVolumeMap = new HashMap<String, String>();
        HashSet<String> physicalVolumes = new HashSet<String>();
        boolean logicalVolume = false;
        for (String line : Executor.runNative(DISKUTIL_CS_LIST)) {
            if (line.contains(LOGICAL_VOLUME_GROUP)) {
                physicalVolumes.clear();
                logicalVolume = false;
                continue;
            }
            if (line.contains(LOGICAL_VOLUME_FAMILY)) {
                logicalVolume = true;
                continue;
            }
            if (!line.contains("Disk:")) continue;
            String volume = Builder.parseLastString(line);
            if (logicalVolume) {
                for (String pv : physicalVolumes) {
                    logicalVolumeMap.put(pv, volume);
                }
                physicalVolumes.clear();
                continue;
            }
            physicalVolumes.add(Builder.parseLastString(line));
        }
        return logicalVolumeMap;
    }
}

