/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.hardware;

import com.sun.jna.platform.mac.IOKit;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.builtin.hardware.AbstractSensors;
import org.aoju.bus.health.mac.Smc;

@ThreadSafe
final class MacSensors
extends AbstractSensors {
    private int numFans = 0;

    MacSensors() {
    }

    @Override
    public double queryCpuTemperature() {
        IOKit.IOConnect conn = Smc.smcOpen();
        double temp = Smc.smcGetFloat(conn, "TC0P");
        Smc.smcClose(conn);
        if (temp > 0.0) {
            return temp;
        }
        return 0.0;
    }

    @Override
    public int[] queryFanSpeeds() {
        IOKit.IOConnect conn = Smc.smcOpen();
        if (this.numFans == 0) {
            this.numFans = (int)Smc.smcGetLong(conn, "FNum");
        }
        int[] fanSpeeds = new int[this.numFans];
        for (int i = 0; i < this.numFans; ++i) {
            fanSpeeds[i] = (int)Smc.smcGetFloat(conn, String.format("F%dAc", i));
        }
        Smc.smcClose(conn);
        return fanSpeeds;
    }

    @Override
    public double queryCpuVoltage() {
        IOKit.IOConnect conn = Smc.smcOpen();
        double volts = Smc.smcGetFloat(conn, "VC0C") / 1000.0;
        Smc.smcClose(conn);
        return volts;
    }
}

