/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.hardware;

import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.builtin.hardware.AbstractSoundCard;

@Immutable
final class MacSoundCard
extends AbstractSoundCard {
    private static final String APPLE = "Apple Inc.";

    MacSoundCard(String kernelVersion, String name, String codec) {
        super(kernelVersion, name, codec);
    }

    public static List<MacSoundCard> getSoundCards() {
        ArrayList<MacSoundCard> soundCards = new ArrayList<MacSoundCard>();
        String manufacturer = APPLE;
        String kernelVersion = "AppleHDAController";
        String codec = "AppleHDACodec";
        boolean version = false;
        String versionMarker = "<key>com.apple.driver.AppleHDAController</key>";
        for (String checkLine : Builder.readFile("/System/Library/Extensions/AppleHDA.kext/Contents/Info.plist")) {
            if (checkLine.contains(versionMarker)) {
                version = true;
                continue;
            }
            if (!version) continue;
            kernelVersion = "AppleHDAController " + Builder.getTextBetweenStrings(checkLine, "<string>", "</string>");
            version = false;
        }
        soundCards.add(new MacSoundCard(kernelVersion, manufacturer, codec));
        return soundCards;
    }
}

