/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.software;

import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.software.InternetProtocolStats;
import org.aoju.bus.health.mac.Sysctl;
import org.aoju.bus.health.unix.CLibrary;

@ThreadSafe
public class MacInternetProtocolStats
implements InternetProtocolStats {
    private boolean isElevated;
    private Supplier<Pair<Long, Long>> establishedv4v6 = Memoize.memoize(MacInternetProtocolStats::queryTcpnetstat, Memoize.defaultExpiration());
    private Supplier<CLibrary.Tcpstat> tcpstat = Memoize.memoize(MacInternetProtocolStats::queryTcpstat, Memoize.defaultExpiration());
    private Supplier<CLibrary.Udpstat> udpstat = Memoize.memoize(MacInternetProtocolStats::queryUdpstat, Memoize.defaultExpiration());
    private Supplier<CLibrary.Ipstat> ipstat = Memoize.memoize(MacInternetProtocolStats::queryIpstat, Memoize.defaultExpiration());
    private Supplier<CLibrary.Ip6stat> ip6stat = Memoize.memoize(MacInternetProtocolStats::queryIp6stat, Memoize.defaultExpiration());

    public MacInternetProtocolStats(boolean elevated) {
        this.isElevated = elevated;
    }

    private static CLibrary.Tcpstat queryTcpstat() {
        CLibrary.Tcpstat tcpstat = new CLibrary.Tcpstat();
        Sysctl.sysctl("net.inet.tcp.stats", tcpstat);
        return tcpstat;
    }

    private static CLibrary.Ipstat queryIpstat() {
        CLibrary.Ipstat ipstat = new CLibrary.Ipstat();
        Sysctl.sysctl("net.inet.ip.stats", ipstat);
        return ipstat;
    }

    private static CLibrary.Ip6stat queryIp6stat() {
        CLibrary.Ip6stat ip6stat = new CLibrary.Ip6stat();
        Sysctl.sysctl("net.inet6.ip6.stats", ip6stat);
        return ip6stat;
    }

    private static CLibrary.Udpstat queryUdpstat() {
        CLibrary.Udpstat udpstat = new CLibrary.Udpstat();
        Sysctl.sysctl("net.inet.udp.stats", udpstat);
        return udpstat;
    }

    private static Pair<Long, Long> queryTcpnetstat() {
        long tcp4 = 0L;
        long tcp6 = 0L;
        List<String> activeConns = Executor.runNative("netstat -n -p tcp");
        for (String s : activeConns) {
            if (!s.endsWith("ESTABLISHED")) continue;
            if (s.startsWith("tcp4")) {
                ++tcp4;
                continue;
            }
            if (!s.startsWith("tcp6")) continue;
            ++tcp6;
        }
        return Pair.of(tcp4, tcp6);
    }

    @Override
    public InternetProtocolStats.TcpStats getTCPv4Stats() {
        CLibrary.Tcpstat tcp = this.tcpstat.get();
        if (this.isElevated) {
            return new InternetProtocolStats.TcpStats(this.establishedv4v6.get().getLeft(), Builder.unsignedIntToLong(tcp.tcps_connattempt), Builder.unsignedIntToLong(tcp.tcps_accepts), Builder.unsignedIntToLong(tcp.tcps_conndrops), Builder.unsignedIntToLong(tcp.tcps_drops), Builder.unsignedIntToLong(tcp.tcps_snd_swcsum - tcp.tcps_sndrexmitpack), Builder.unsignedIntToLong(tcp.tcps_rcv_swcsum), Builder.unsignedIntToLong(tcp.tcps_sndrexmitpack), Builder.unsignedIntToLong(tcp.tcps_rcvbadsum + tcp.tcps_rcvbadoff + tcp.tcps_rcvmemdrop + tcp.tcps_rcvshort), 0L);
        }
        CLibrary.Ipstat ip = this.ipstat.get();
        CLibrary.Udpstat udp = this.udpstat.get();
        return new InternetProtocolStats.TcpStats(this.establishedv4v6.get().getLeft(), Builder.unsignedIntToLong(tcp.tcps_connattempt), Builder.unsignedIntToLong(tcp.tcps_accepts), Builder.unsignedIntToLong(tcp.tcps_conndrops), Builder.unsignedIntToLong(tcp.tcps_drops), Math.max(0L, Builder.unsignedIntToLong(ip.ips_snd_swcsum - udp.udps_snd_swcsum - tcp.tcps_sndrexmitpack)), Math.max(0L, Builder.unsignedIntToLong(ip.ips_rcv_swcsum - udp.udps_rcv_swcsum)), Builder.unsignedIntToLong(tcp.tcps_sndrexmitpack), Math.max(0L, Builder.unsignedIntToLong(ip.ips_badsum + ip.ips_tooshort + ip.ips_toosmall + ip.ips_badhlen + ip.ips_badlen - udp.udps_hdrops + udp.udps_badsum + udp.udps_badlen)), 0L);
    }

    @Override
    public InternetProtocolStats.TcpStats getTCPv6Stats() {
        CLibrary.Ip6stat ip6 = this.ip6stat.get();
        CLibrary.Udpstat udp = this.udpstat.get();
        return new InternetProtocolStats.TcpStats(this.establishedv4v6.get().getRight(), 0L, 0L, 0L, 0L, ip6.ip6s_localout - Builder.unsignedIntToLong(udp.udps_snd6_swcsum), ip6.ip6s_total - Builder.unsignedIntToLong(udp.udps_rcv6_swcsum), 0L, 0L, 0L);
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv4Stats() {
        CLibrary.Udpstat stat = this.udpstat.get();
        return new InternetProtocolStats.UdpStats(Builder.unsignedIntToLong(stat.udps_snd_swcsum), Builder.unsignedIntToLong(stat.udps_rcv_swcsum), Builder.unsignedIntToLong(stat.udps_noportmcast), Builder.unsignedIntToLong(stat.udps_hdrops + stat.udps_badsum + stat.udps_badlen));
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv6Stats() {
        CLibrary.Udpstat stat = this.udpstat.get();
        return new InternetProtocolStats.UdpStats(Builder.unsignedIntToLong(stat.udps_snd6_swcsum), Builder.unsignedIntToLong(stat.udps_rcv6_swcsum), 0L, 0L);
    }
}

