/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.hardware;

import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.tuple.Quartet;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractComputerSystem;
import org.aoju.bus.health.builtin.hardware.Baseboard;
import org.aoju.bus.health.builtin.hardware.Firmware;
import org.aoju.bus.health.unix.freebsd.hardware.FreeBsdBaseboard;
import org.aoju.bus.health.unix.freebsd.hardware.FreeBsdFirmware;

@Immutable
final class FreeBsdComputerSystem
extends AbstractComputerSystem {
    private final Supplier<Quartet<String, String, String, String>> manufModelSerialVers = Memoize.memoize(FreeBsdComputerSystem::readDmiDecode);

    FreeBsdComputerSystem() {
    }

    private static Quartet<String, String, String, String> readDmiDecode() {
        String manufacturer = null;
        String model = null;
        String serialNumber = null;
        String version = null;
        String manufacturerMarker = "Manufacturer:";
        String productNameMarker = "Product Name:";
        String serialNumMarker = "Serial Number:";
        String versionMarker = "Version:";
        for (String checkLine : Executor.runNative("dmidecode -t system")) {
            if (checkLine.contains("Manufacturer:")) {
                manufacturer = checkLine.split("Manufacturer:")[1].trim();
                continue;
            }
            if (checkLine.contains("Product Name:")) {
                model = checkLine.split("Product Name:")[1].trim();
                continue;
            }
            if (checkLine.contains("Serial Number:")) {
                serialNumber = checkLine.split("Serial Number:")[1].trim();
                continue;
            }
            if (!checkLine.contains("Version:")) continue;
            version = checkLine.split("Version:")[1].trim();
        }
        if (StringUtils.isBlank(serialNumber)) {
            serialNumber = FreeBsdComputerSystem.querySystemSerialNumber();
        }
        return new Quartet<String, String, String, String>(StringUtils.isBlank(manufacturer) ? "unknown" : manufacturer, StringUtils.isBlank(model) ? "unknown" : model, StringUtils.isBlank(serialNumber) ? "unknown" : serialNumber, StringUtils.isBlank(version) ? "unknown" : version);
    }

    private static String querySystemSerialNumber() {
        String marker = "system.hardware.serial =";
        for (String checkLine : Executor.runNative("lshal")) {
            if (!checkLine.contains(marker)) continue;
            return Builder.getSingleQuoteStringValue(checkLine);
        }
        return "unknown";
    }

    @Override
    public String getManufacturer() {
        return this.manufModelSerialVers.get().getA();
    }

    @Override
    public String getModel() {
        return this.manufModelSerialVers.get().getB();
    }

    @Override
    public String getSerialNumber() {
        return this.manufModelSerialVers.get().getC();
    }

    @Override
    public Firmware createFirmware() {
        return new FreeBsdFirmware();
    }

    @Override
    public Baseboard createBaseboard() {
        return new FreeBsdBaseboard(this.manufModelSerialVers.get().getA(), this.manufModelSerialVers.get().getB(), this.manufModelSerialVers.get().getC(), this.manufModelSerialVers.get().getD());
    }
}

