/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.builtin;

import java.util.Arrays;
import java.util.EnumSet;
import org.aoju.bus.image.UID;
import org.aoju.bus.image.builtin.DeIdentificationMethod;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.Code;
import org.aoju.bus.image.galaxy.data.ElementDictionary;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.VR;

public class DeIdentifier {
    private static final int[] X = new int[]{1589248, 0x400555, 1610788, 4210741, 1057200, 4236115, 3670032, 528516, 528512, 0x102110, 0x40000010, 4235384, 0x101081, 4194944, 4206593, 524445, 7340166, 4237104, 1613827, 1057104, 4236039, 0x380300, 4235388, 4235553, 4235552, -196612, 532753, 0x4000100, -327686, 3670084, 3670080, 1074266394, 1074266393, 1057120, 2134360, 0x700001, 0x404009, 4210743, 4210742, 0x880200, 540672, 0x204000, 2637824, 0x402400, 1074266880, 0x101050, 0x401011, 1074266385, 1074266380, 1074266389, 1074266626, 1074266370, 1074266379, 1074266378, 524369, 3670033, 3670036, 0x100021, 1048612, 3670113, 0x4000404, 0x102000, 0x101090, 0x101080, 0x4000550, 2110470, 2110465, 528480, 0x401010, 1057152, 528498, 4202512, 4202513, 4202504, 4202505, 67110241, 0x101000, 0x101002, 0x101001, 4235386, 0x101040, 0x104000, 3671296, 0x401004, 0x101010, 0x101005, 1048626, 3671040, 0x100050, 0x101060, 0x100101, 0x100102, 1057264, 0x101020, 0x101021, 1057109, 1057108, 0x101030, 4194883, 4194900, 4194899, 528466, 528464, 4198658, 0x401101, 4235555, 0x401104, 4198659, 1074266388, 528482, 528456, 528457, 4194322, 1057216, 806093075, 4202497, 3280944, 0x4000402, 3670020, 0x101100, 528672, 0x4000403, 524434, 524438, 524436, 1057106, 4194933, 3281008, 0x401400, 0x401001, 4198405, 3280946, 3280945, 3280947, 3280948, 1057433, 1057431, 0x40084000, 1074266392, 1074266178, 0x404034, 3670046, 0x40000B, 0x400006, 0x400007, 528446, 528447, 3670114, 3670112, 1057184, 3670096, 3293184, 528432, 3276818, 4236116, 0x40004000, 0x20300020, 4235616, 4235554, 8915216, 8915218, 8915206, 8915204, 4236114, 4236120, 3686400};
    private static final int[] X_INSTITUTION = new int[]{524417, 528448};
    private static final int[] X_DEVICE = new int[]{1576967, 0x181008, 1576965, 4194881, 0x404030, 0x400242, 4210728, 1576964, 0x400011, 0x400001, 4210727, 0x400010, 4210725, 3280928, 3280929, 805830917};
    private static final int[] X_DATES = new int[]{524325, 524341, 0x404011, 524309, 524306, 524307, 1057232, 4235314, 4235666, 4235667, 524324, 524340, 4194896, 4210769, 4194897, 0x400244, 0x404050, 4194885, 4210770, 0x400004, 0x400005, 0x404010, 0x400002, 0x404005, 0x400003, 524801};
    private static final int[] Z = new int[]{524368, 524444, 7340164, 4202519, 0x100020, 1057283, 0x100030, 0x100010, 0x100040, 4202518, 524432, 3280992, 806223880, 0x200010, 4235400};
    private static final int[] Z_INSTITUTION = new int[]{524418};
    private static final int[] Z_DATES = new int[]{524322, 524338, 3670048, 3670049, 524321, 524337, 524320, 524336};
    private static final int[] Z_UID = new int[]{528657, 528656};
    private static final int[] D = new int[]{1577984, 0x180010, 805961747, 528496, 4235555, 1577008, 4235381, 4235303};
    private static final int[] D_DEVICE = new int[]{1601546, 0x181000, 528400};
    private static final int[] D_INSTITUTION = new int[]{524416};
    private static final int[] D_DATES = new int[]{524330, 524323, 524339, 1611031, 1611030, 4235312};
    private static final int[] U = new int[]{4096, 2134369, 2134372, 524376, 7340826, 0x200052, 524308, 536592, 2626068, 131075, 4236290, 4235633, 2625945, 0x701101, 7344386, 805699620, 4210723, 4235634, 528725, 267537, 805699778, 4097, 0x20000E, 524312, 8913216, 0x20000D, 0x200200, 1581122, 4250381, 4250380, 6422561, 528789, 4235556};
    private static final int[] U_DEVICE = new int[]{1576962};
    private static final String UNMODIFIED = "UNMODIFIED";
    private static final String REMOVED = "REMOVED";
    private static final String YES = "YES";
    private final EnumSet<Option> options;
    private final Attributes dummyValues = new Attributes();
    private final int[] o;
    private int[] x = X;
    private int[] u = U;

    public DeIdentifier(Option ... options) {
        this.options = EnumSet.of(Option.BasicApplicationConfidentialityProfile, options);
        int[] z = Z;
        int[] d = D;
        if (!this.options.contains((Object)Option.RetainDeviceIdentityOption)) {
            this.x = DeIdentifier.cat(this.x, X_DEVICE);
            d = DeIdentifier.cat(d, D_DEVICE);
            this.u = DeIdentifier.cat(this.u, U_DEVICE);
        }
        if (!this.options.contains((Object)Option.RetainInstitutionIdentityOption)) {
            this.x = DeIdentifier.cat(this.x, X_INSTITUTION);
            z = DeIdentifier.cat(z, Z_INSTITUTION);
            d = DeIdentifier.cat(d, D_INSTITUTION);
        }
        if (!this.options.contains((Object)Option.RetainLongitudinalTemporalInformationFullDatesOption)) {
            this.x = DeIdentifier.cat(this.x, X_DATES);
            z = DeIdentifier.cat(z, Z_DATES);
            d = DeIdentifier.cat(d, D_DATES);
        }
        if (!this.options.contains((Object)Option.RetainUIDsOption)) {
            z = DeIdentifier.cat(z, Z_UID);
        }
        this.o = DeIdentifier.cat(z, d);
        Arrays.sort(this.x);
        Arrays.sort(this.u);
        Arrays.sort(this.o);
        this.initDummyValues(d);
    }

    private static int[] cat(int[] a, int[] b) {
        int[] dest = new int[a.length + b.length];
        System.arraycopy(a, 0, dest, 0, a.length);
        System.arraycopy(b, 0, dest, a.length, b.length);
        return dest;
    }

    private static String dummyValueFor(VR vr) {
        switch (vr) {
            case DA: {
                return "19991111";
            }
            case DT: {
                return "19991111111111";
            }
            case TM: {
                return "111111";
            }
            case IS: 
            case DS: {
                return "0";
            }
        }
        return REMOVED;
    }

    public void setDummyValue(int tag, VR vr, String s) {
        this.dummyValues.setString(tag, vr, s);
    }

    public void deidentify(Attributes attrs) {
        this.deidentifyItem(attrs);
        this.correct(attrs);
        attrs.setString(1179746, VR.CS, YES);
        attrs.setString(2622211, VR.CS, this.options.contains((Object)Option.RetainLongitudinalTemporalInformationFullDatesOption) ? UNMODIFIED : REMOVED);
        Sequence sq = attrs.ensureSequence(1179748, this.options.size());
        for (Option option : this.options) {
            sq.add(option.code.toItem());
        }
    }

    public String remapUID(String uid) {
        return this.options.contains((Object)Option.RetainUIDsOption) ? uid : UID.remapUID(uid);
    }

    public boolean equalOptions(Option ... options) {
        return EnumSet.of(Option.BasicApplicationConfidentialityProfile, options).equals(options);
    }

    private void initDummyValues(int[] d) {
        ElementDictionary dict = ElementDictionary.getStandardElementDictionary();
        for (int tag : d) {
            this.initDummyValue(dict.vrOf(tag), tag);
        }
        this.initDummyValue(VR.DA, 524321);
        this.initDummyValue(VR.TM, 524337);
    }

    private Object initDummyValue(VR vr, int tag) {
        return this.dummyValues.setString(tag, vr, DeIdentifier.dummyValueFor(vr));
    }

    private void correct(Attributes attrs) {
        if (!this.options.contains((Object)Option.RetainLongitudinalTemporalInformationFullDatesOption) && "1.2.840.10008.5.1.4.1.1.128".equals(attrs.getString(524310))) {
            attrs.setString(524321, VR.DA, this.dummyValues.getString(524321));
            attrs.setString(524337, VR.TM, this.dummyValues.getString(524337));
        }
    }

    private void deidentifyItem(Attributes attrs) {
        attrs.removePrivateAttributes();
        attrs.removeCurveData();
        attrs.removeOverlayData();
        attrs.removeSelected(this.x);
        attrs.replaceSelected(this.dummyValues, this.o);
        if (!this.options.contains((Object)Option.RetainUIDsOption)) {
            attrs.replaceUIDSelected(this.u);
        }
        try {
            attrs.accept(new Attributes.Visitor(){

                @Override
                public boolean visit(Attributes attrs, int tag, VR vr, Object value) throws Exception {
                    if (value instanceof Sequence) {
                        for (Attributes item : (Sequence)value) {
                            DeIdentifier.this.deidentifyItem(item);
                        }
                    }
                    return true;
                }
            }, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Option {
        BasicApplicationConfidentialityProfile(DeIdentificationMethod.BasicApplicationConfidentialityProfile),
        RetainLongitudinalTemporalInformationFullDatesOption(DeIdentificationMethod.RetainLongitudinalTemporalInformationFullDatesOption),
        RetainDeviceIdentityOption(DeIdentificationMethod.RetainDeviceIdentityOption),
        RetainInstitutionIdentityOption(DeIdentificationMethod.RetainInstitutionIdentityOption),
        RetainUIDsOption(DeIdentificationMethod.RetainUIDsOption);

        private final Code code;

        private Option(Code code) {
            this.code = code;
        }
    }
}

