/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.net;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.SocketListener;
import org.aoju.bus.image.metric.internal.net.UDPHandler;
import org.aoju.bus.logger.Logger;

public class UDPListener
implements SocketListener {
    private final Connection conn;
    private final UDPHandler handler;
    private final DatagramSocket ds;

    public UDPListener(Connection conn, UDPHandler handler) throws IOException {
        this.conn = conn;
        this.handler = handler;
        try {
            this.ds = new DatagramSocket(conn.getBindPoint());
        }
        catch (BindException e) {
            throw new IOException("Cannot start UDP listener on " + conn.getBindPoint().getHostName() + ":" + conn.getBindPoint().getPort(), e);
        }
        conn.setReceiveBufferSize(this.ds);
        conn.getDevice().execute(() -> this.listen());
    }

    private void listen() {
        SocketAddress sockAddr = this.ds.getLocalSocketAddress();
        Logger.info("Start UDP listener on {}", sockAddr);
        byte[] data = new byte[65536];
        block4: while (true) {
            try {
                while (!this.ds.isClosed()) {
                    Logger.debug("Wait for UDP datagram package on {}", sockAddr);
                    DatagramPacket dp = new DatagramPacket(data, 65536);
                    this.ds.receive(dp);
                    InetAddress senderAddr = dp.getAddress();
                    if (this.conn.isBlackListed(dp.getAddress())) {
                        Logger.info("Ignore UDP datagram package received from blacklisted {}", senderAddr);
                        continue;
                    }
                    Logger.info("Received UDP datagram package from {}", senderAddr);
                    try {
                        this.handler.onReceive(this.conn, dp);
                        continue block4;
                    }
                    catch (Throwable e) {
                        Logger.warn("Exception processing UDP received from {}:", senderAddr, e);
                    }
                }
                break;
            }
            catch (Throwable e) {
                if (this.ds.isClosed()) break;
                Logger.error("Exception on listing on {}:", sockAddr, e);
                break;
            }
        }
        Logger.info("Stop UDP listener on {}", sockAddr);
    }

    @Override
    public SocketAddress getEndPoint() {
        return this.ds.getLocalSocketAddress();
    }

    @Override
    public void close() {
        try {
            this.ds.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

