/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.reader;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.aoju.bus.core.utils.ByteUtils;
import org.aoju.bus.logger.Logger;

public class ImageReader
extends javax.imageio.ImageReader {
    private static final String UNKNOWN_IMAGE_TYPE = "RLE Image Reader needs ImageReadParam.destination or ImageReadParam.destinationType specified";
    private static final String UNSUPPORTED_DATA_TYPE = "Unsupported Data Type of ImageReadParam.destination or ImageReadParam.destinationType: ";
    private static final String MISMATCH_NUM_RLE_SEGMENTS = "Number of RLE Segments does not match image type: ";
    private final int[] header = new int[16];
    private final byte[] buf = new byte[8192];
    private long headerPos;
    private long bufOff;
    private int bufPos;
    private int bufLen;
    private ImageInputStream iis;
    private int width;
    private int height;

    protected ImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.resetInternalState();
        this.iis = (ImageInputStream)input;
        try {
            this.headerPos = this.iis.getStreamPosition();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void resetInternalState() {
        this.width = 0;
        this.height = 0;
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        return this.width;
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        return this.height;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public boolean canReadRaster() {
        return true;
    }

    @Override
    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        WritableRaster raster = this.getDestinationRaster(param);
        this.read(raster.getDataBuffer());
        return raster;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        BufferedImage bi = this.getDestination(param);
        this.read(bi.getRaster().getDataBuffer());
        return bi;
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("imageIndex: " + imageIndex);
        }
    }

    private BufferedImage getDestination(ImageReadParam param) {
        if (param == null) {
            throw new IllegalArgumentException(UNKNOWN_IMAGE_TYPE);
        }
        BufferedImage bi = param.getDestination();
        if (bi != null) {
            this.width = bi.getWidth();
            this.height = bi.getHeight();
            return bi;
        }
        ImageTypeSpecifier imageType = param.getDestinationType();
        if (imageType != null) {
            SampleModel sm = imageType.getSampleModel();
            this.width = sm.getWidth();
            this.height = sm.getHeight();
            return imageType.createBufferedImage(this.width, this.height);
        }
        throw new IllegalArgumentException(UNKNOWN_IMAGE_TYPE);
    }

    private WritableRaster getDestinationRaster(ImageReadParam param) {
        if (param == null) {
            throw new IllegalArgumentException(UNKNOWN_IMAGE_TYPE);
        }
        BufferedImage bi = param.getDestination();
        if (bi != null) {
            this.width = bi.getWidth();
            this.height = bi.getHeight();
            return bi.getRaster();
        }
        ImageTypeSpecifier imageType = param.getDestinationType();
        if (imageType != null) {
            SampleModel sm = imageType.getSampleModel();
            this.width = sm.getWidth();
            this.height = sm.getHeight();
            return Raster.createWritableRaster(sm, null);
        }
        throw new IllegalArgumentException(UNKNOWN_IMAGE_TYPE);
    }

    private void read(DataBuffer db) throws IOException {
        switch (db.getDataType()) {
            case 0: {
                this.read(((DataBufferByte)db).getBankData());
                break;
            }
            case 1: {
                this.read(((DataBufferUShort)db).getData());
                break;
            }
            case 2: {
                this.read(((DataBufferShort)db).getData());
                break;
            }
            default: {
                throw new IllegalArgumentException(UNSUPPORTED_DATA_TYPE + db.getDataType());
            }
        }
    }

    private void read(byte[][] bands) throws IOException {
        this.readRLEHeader(bands.length);
        for (int i = 0; i < bands.length; ++i) {
            this.unrle(i + 1, bands[i]);
        }
    }

    private void read(short[] data) throws IOException {
        this.readRLEHeader(2);
        Arrays.fill(data, (short)0);
        this.unrle(1, data);
        this.unrle(2, data);
    }

    private void seekSegment(int seg) throws IOException {
        long streamPos = this.headerPos + ((long)this.header[seg] & 0xFFFFFFFFL);
        int bufPos = (int)(streamPos - this.bufOff);
        if (bufPos >= 0 && bufPos <= this.bufLen) {
            this.bufPos = bufPos;
        } else {
            this.iis.seek(streamPos);
            this.bufPos = this.bufLen;
        }
    }

    private void readRLEHeader(int numSegments) throws IOException {
        this.fillBuffer();
        if (this.bufLen < 64) {
            throw new EOFException();
        }
        int i = 0;
        int off = 0;
        while (i < this.header.length) {
            this.header[i] = ByteUtils.bytesToIntLE(this.buf, off);
            ++i;
            off += 4;
        }
        this.bufPos = 64;
        if (this.header[0] != numSegments) {
            throw new IOException(MISMATCH_NUM_RLE_SEGMENTS + this.header[0]);
        }
    }

    private void unrle(int seg, byte[] data) throws IOException {
        this.seekSegment(seg);
        int pos = 0;
        try {
            while (pos < data.length) {
                int n = this.nextByte();
                if (n >= 0) {
                    this.read(data, pos, ++n);
                    pos += n;
                    continue;
                }
                if (n == -128) continue;
                int end = pos + 1 - n;
                byte val = this.nextByte();
                while (pos < end) {
                    data[pos++] = val;
                }
            }
        }
        catch (EOFException e) {
            Logger.info("RLE Segment #{} too short, set missing {} bytes to 0", seg, data.length - pos);
        }
        catch (IndexOutOfBoundsException e) {
            Logger.info("RLE Segment #{} too long, truncate surplus bytes", seg);
        }
    }

    private void read(byte[] data, int pos, int len) throws IOException {
        int remaining = len;
        while (remaining > 0) {
            int n = this.bufLen - this.bufPos;
            if (n <= 0) {
                this.fillBuffer();
                n = this.bufLen - this.bufPos;
            }
            if ((remaining -= n) < 0) {
                n += remaining;
            }
            System.arraycopy(this.buf, this.bufPos, data, pos, n);
            this.bufPos += n;
            pos += n;
        }
    }

    private void unrle(int seg, short[] data) throws IOException {
        this.seekSegment(seg);
        int pos = 0;
        try {
            int shift;
            int n = shift = seg == 1 ? 8 : 0;
            while (pos < data.length) {
                int n2 = this.nextByte();
                if (n2 >= 0) {
                    this.read(data, pos, ++n2, shift);
                    pos += n2;
                    continue;
                }
                if (n2 == -128) continue;
                int end = pos + 1 - n2;
                int val = (this.nextByte() & 0xFF) << shift;
                while (pos < end) {
                    int n3 = pos++;
                    data[n3] = (short)(data[n3] | val);
                }
            }
        }
        catch (EOFException e) {
            Logger.info("RLE Segment #{} too short, set missing {} bytes to 0", seg, data.length - pos);
        }
        catch (IndexOutOfBoundsException e) {
            Logger.info("RLE Segment #{} to long, truncate surplus bytes", seg);
        }
    }

    private void read(short[] data, int pos, int len, int shift) throws IOException {
        int remaining = len;
        while (remaining > 0) {
            int n = this.bufLen - this.bufPos;
            if (n <= 0) {
                this.fillBuffer();
                n = this.bufLen - this.bufPos;
            }
            if ((remaining -= n) < 0) {
                n += remaining;
            }
            while (n-- > 0) {
                int n2 = pos++;
                data[n2] = (short)(data[n2] | (this.buf[this.bufPos++] & 0xFF) << shift);
            }
        }
    }

    private void fillBuffer() throws IOException {
        this.bufOff = this.iis.getStreamPosition();
        this.bufPos = 0;
        this.bufLen = this.iis.read(this.buf);
        if (this.bufLen <= 0) {
            throw new EOFException();
        }
    }

    private byte nextByte() throws IOException {
        if (this.bufPos >= this.bufLen) {
            this.fillBuffer();
        }
        return this.buf[this.bufPos++];
    }
}

