/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.text.MessageFormat;
import org.aoju.bus.image.Args;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.Node;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.plugin.StoreSCU;
import org.aoju.bus.logger.Logger;

public class Echo {
    public static Status process(String callingAET, Node calledNode) {
        return Echo.process(new Node(callingAET), calledNode);
    }

    public static Status process(Node callingNode, Node calledNode) {
        return Echo.process(null, callingNode, calledNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status process(Args args, Node callingNode, Node calledNode) {
        Status status;
        if (callingNode == null || calledNode == null) {
            throw new IllegalArgumentException("callingNode or calledNode cannot be null!");
        }
        Device device = new Device("storescu");
        Connection conn = new Connection();
        device.addConnection(conn);
        ApplicationEntity ae = new ApplicationEntity(callingNode.getAet());
        device.addApplicationEntity(ae);
        ae.addConnection(conn);
        StoreSCU storeSCU = new StoreSCU(ae, null);
        Connection remote = storeSCU.getRemoteConnection();
        args.configureBind(storeSCU.getAAssociateRQ(), remote, calledNode);
        args.configureBind(ae, conn, callingNode);
        args.configure(conn);
        args.configureTLS(conn, remote);
        storeSCU.setPriority(args.getPriority());
        device.start();
        try {
            long t1 = System.currentTimeMillis();
            storeSCU.open();
            long t2 = System.currentTimeMillis();
            Attributes rsp = storeSCU.echo();
            long t3 = System.currentTimeMillis();
            String message = MessageFormat.format("Successful DICOM Echo. Connected in {2}ms from {0} to {1}. Service execution in {3}ms.", storeSCU.getAAssociateRQ().getCallingAET(), storeSCU.getAAssociateRQ().getCalledAET(), t2 - t1, t3 - t2);
            status = new Status(rsp.getInt(2304, 0), message, null);
        }
        catch (Throwable throwable) {
            try {
                Builder.close(storeSCU);
                device.stop();
                throw throwable;
            }
            catch (Exception e) {
                String message = "DICOM Echo failed, storescu: " + e.getMessage();
                Logger.error(message, e);
                return new Status(49152, message, null);
            }
        }
        Builder.close(storeSCU);
        device.stop();
        return status;
    }
}

