/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.text.DecimalFormat;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.Option;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.aoju.bus.image.galaxy.io.SAXReader;
import org.aoju.bus.image.galaxy.io.SAXWriter;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.DimseRSPHandler;
import org.aoju.bus.image.metric.Progress;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRQ;
import org.aoju.bus.image.metric.internal.pdu.ExtendedNegotiate;
import org.aoju.bus.image.metric.internal.pdu.Presentation;
import org.aoju.bus.logger.Logger;

public class FindSCU
extends Device
implements AutoCloseable {
    private final Device device = new Device("findscu");
    private final ApplicationEntity ae = new ApplicationEntity("FINDSCU");
    private final Connection conn = new Connection();
    private final Connection remote = new Connection();
    private final AAssociateRQ rq = new AAssociateRQ();
    private final Attributes keys = new Attributes();
    private final AtomicInteger totNumMatches = new AtomicInteger();
    private final Status state;
    private SAXTransformerFactory saxtf;
    private int priority;
    private int cancelAfter;
    private InformationModel model;
    private File outDir;
    private DecimalFormat outFileFormat;
    private int[] inFilter;
    private boolean catOut = false;
    private boolean xml = false;
    private boolean xmlIndent = false;
    private boolean xmlIncludeKeyword = true;
    private boolean xmlIncludeNamespaceDeclaration = false;
    private File xsltFile;
    private Templates xsltTpls;
    private OutputStream out;
    private Association as;

    public FindSCU() {
        this.device.addConnection(this.conn);
        this.device.addApplicationEntity(this.ae);
        this.ae.addConnection(this.conn);
        this.state = new Status(new Progress());
    }

    static void mergeKeys(Attributes attrs, Attributes keys) {
        try {
            attrs.accept(new MergeNested(keys), false);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        attrs.addAll(keys);
    }

    public final void setPriority(int priority) {
        this.priority = priority;
    }

    public final void setInformationModel(InformationModel model, String[] tss, EnumSet<Option.Type> types) {
        this.model = model;
        this.rq.addPresentationContext(new Presentation(1, model.cuid, tss));
        if (!types.isEmpty()) {
            model.adjustQueryOptions(types);
            this.rq.addExtendedNegotiate(new ExtendedNegotiate(model.cuid, Option.Type.toExtendedNegotiationInformation(types)));
        }
        if (model.level != null) {
            this.addLevel(model.level);
        }
    }

    public void addLevel(String s) {
        this.keys.setString(524370, VR.CS, s);
    }

    public final void setCancelAfter(int cancelAfter) {
        this.cancelAfter = cancelAfter;
    }

    public final void setOutputDirectory(File outDir) {
        outDir.mkdirs();
        this.outDir = outDir;
    }

    public final void setOutputFileFormat(String outFileFormat) {
        this.outFileFormat = new DecimalFormat(outFileFormat);
    }

    public final void setXSLT(File xsltFile) {
        this.xsltFile = xsltFile;
    }

    public final void setXML(boolean xml) {
        this.xml = xml;
    }

    public final void setXMLIndent(boolean indent) {
        this.xmlIndent = indent;
    }

    public final void setXMLIncludeKeyword(boolean includeKeyword) {
        this.xmlIncludeKeyword = includeKeyword;
    }

    public final void setXMLIncludeNamespaceDeclaration(boolean includeNamespaceDeclaration) {
        this.xmlIncludeNamespaceDeclaration = includeNamespaceDeclaration;
    }

    public final void setConcatenateOutputFiles(boolean catOut) {
        this.catOut = catOut;
    }

    public final void setInputFilter(int[] inFilter) {
        this.inFilter = inFilter;
    }

    public ApplicationEntity getApplicationEntity() {
        return this.ae;
    }

    public Connection getRemoteConnection() {
        return this.remote;
    }

    public AAssociateRQ getAAssociateRQ() {
        return this.rq;
    }

    public Association getAssociation() {
        return this.as;
    }

    public Device getDevice() {
        return this.device;
    }

    public Attributes getKeys() {
        return this.keys;
    }

    public void open() throws IOException, InterruptedException, GeneralSecurityException {
        this.as = this.ae.connect(this.conn, this.remote, this.rq);
    }

    @Override
    public void close() throws IOException, InterruptedException {
        if (this.as != null && this.as.isReadyForDataTransfer()) {
            this.as.waitForOutstandingRSP();
            this.as.release();
        }
        IoUtils.close(this.out);
        this.out = null;
    }

    public void query(File f) throws Exception {
        Attributes attrs;
        String filePath = f.getPath();
        String fileExt = filePath.substring(filePath.lastIndexOf(46) + 1).toLowerCase();
        if (fileExt.equals("xml")) {
            attrs = SAXReader.parse(filePath);
        } else {
            try (ImageInputStream dis = new ImageInputStream(f);){
                attrs = dis.readDataset(-1, -1);
            }
        }
        if (this.inFilter != null) {
            attrs = new Attributes(this.inFilter.length + 1);
            attrs.addSelected(attrs, this.inFilter);
        }
        FindSCU.mergeKeys(attrs, this.keys);
        this.query(attrs);
    }

    public void query() throws IOException, InterruptedException {
        this.query(this.keys);
    }

    private void query(Attributes keys) throws IOException, InterruptedException {
        DimseRSPHandler rspHandler = new DimseRSPHandler(this.as.nextMessageID()){
            int cancelAfter;
            int numMatches;
            {
                this.cancelAfter = FindSCU.this.cancelAfter;
            }

            @Override
            public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                super.onDimseRSP(as, cmd, data);
                int status = cmd.getInt(2304, -1);
                if (Status.isPending(status)) {
                    FindSCU.this.onResult(data);
                    ++this.numMatches;
                    if (this.cancelAfter != 0 && this.numMatches >= this.cancelAfter) {
                        try {
                            this.cancel(as);
                            this.cancelAfter = 0;
                        }
                        catch (IOException e) {
                            Logger.error("Building response", e);
                        }
                    }
                } else {
                    FindSCU.this.state.setStatus(status);
                }
            }
        };
        this.query(keys, rspHandler);
    }

    public void query(DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.query(this.keys, rspHandler);
    }

    private void query(Attributes keys, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.as.cfind(this.model.cuid, this.priority, keys, null, rspHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResult(Attributes data) {
        this.state.setList(data);
        int numMatches = this.totNumMatches.incrementAndGet();
        if (this.outDir == null) {
            return;
        }
        try {
            if (this.out == null) {
                File f = new File(this.outDir, this.fname(numMatches));
                this.out = new BufferedOutputStream(new FileOutputStream(f));
            }
            if (this.xml) {
                this.writeAsXML(data, this.out);
            } else {
                ImageOutputStream dos = new ImageOutputStream(this.out, "1.2.840.10008.1.2");
                dos.writeDataset(null, data);
            }
            this.out.flush();
        }
        catch (Exception e) {
            Logger.error("Building response", e);
            IoUtils.close(this.out);
            this.out = null;
        }
        finally {
            if (!this.catOut) {
                IoUtils.close(this.out);
                this.out = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fname(int i) {
        DecimalFormat decimalFormat = this.outFileFormat;
        synchronized (decimalFormat) {
            return this.outFileFormat.format(i);
        }
    }

    private void writeAsXML(Attributes attrs, OutputStream out) throws Exception {
        TransformerHandler th = this.getTransformerHandler();
        th.getTransformer().setOutputProperty("indent", this.xmlIndent ? "yes" : "no");
        th.setResult(new StreamResult(out));
        SAXWriter saxWriter = new SAXWriter(th);
        saxWriter.setIncludeKeyword(this.xmlIncludeKeyword);
        saxWriter.setIncludeNamespaceDeclaration(this.xmlIncludeNamespaceDeclaration);
        saxWriter.write(attrs);
    }

    private TransformerHandler getTransformerHandler() throws Exception {
        SAXTransformerFactory tf = this.saxtf;
        if (tf == null) {
            this.saxtf = tf = (SAXTransformerFactory)TransformerFactory.newInstance();
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        if (this.xsltFile == null) {
            return tf.newTransformerHandler();
        }
        Templates tpls = this.xsltTpls;
        if (tpls == null) {
            this.xsltTpls = tpls = tf.newTemplates(new StreamSource(this.xsltFile));
        }
        return tf.newTransformerHandler(tpls);
    }

    public Connection getConnection() {
        return this.conn;
    }

    public Status getState() {
        return this.state;
    }

    private static class MergeNested
    implements Attributes.Visitor {
        private final Attributes keys;

        MergeNested(Attributes keys) {
            this.keys = keys;
        }

        private static boolean isNotEmptySequence(Object val) {
            return val instanceof Sequence && !((Sequence)val).isEmpty();
        }

        @Override
        public boolean visit(Attributes attrs, int tag, VR vr, Object val) {
            Object o;
            if (MergeNested.isNotEmptySequence(val) && MergeNested.isNotEmptySequence(o = this.keys.remove(tag))) {
                ((Attributes)((Sequence)val).get(0)).addAll((Attributes)((Sequence)o).get(0));
            }
            return true;
        }
    }

    public static enum InformationModel {
        PatientRoot("1.2.840.10008.5.1.4.1.2.1.1", "STUDY"),
        StudyRoot("1.2.840.10008.5.1.4.1.2.2.1", "STUDY"),
        PatientStudyOnly("1.2.840.10008.5.1.4.1.2.3.1", "STUDY"),
        MWL("1.2.840.10008.5.1.4.31", null),
        UPSPull("1.2.840.10008.5.1.4.34.6.3", null),
        UPSWatch("1.2.840.10008.5.1.4.34.6.2", null),
        HangingProtocol("1.2.840.10008.5.1.4.38.2", null),
        ColorPalette("1.2.840.10008.5.1.4.39.2", null);

        final String cuid;
        final String level;

        private InformationModel(String cuid, String level) {
            this.cuid = cuid;
            this.level = level;
        }

        public void adjustQueryOptions(EnumSet<Option.Type> types) {
            if (this.level == null) {
                types.add(Option.Type.RELATIONAL);
                types.add(Option.Type.DATETIME);
            }
        }

        public String getCuid() {
            return this.cuid;
        }
    }
}

