/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.jdk;

import java.io.InputStream;
import java.util.logging.LogManager;
import org.aoju.bus.core.lang.Console;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.ResourceUtils;
import org.aoju.bus.logger.Log;
import org.aoju.bus.logger.LogFactory;
import org.aoju.bus.logger.dialect.jdk.JdkLog;

public class JdkLogFactory
extends LogFactory {
    public JdkLogFactory() {
        super("JDK Logging");
        this.readConfig();
    }

    @Override
    public Log createLog(String name) {
        return new JdkLog(name);
    }

    @Override
    public Log createLog(Class<?> clazz) {
        return new JdkLog(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfig() {
        InputStream in = ResourceUtils.getStreamSafe("logging.properties");
        if (null == in) {
            System.err.println("[WARN] Can not find [logging.properties], use [%JRE_HOME%/lib/logging.properties] as default!");
            return;
        }
        try {
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (Exception e) {
            Console.error(e, "Read [logging.properties] from classpath error!", new Object[0]);
            try {
                LogManager.getLogManager().readConfiguration();
            }
            catch (Exception e1) {
                Console.error(e, "Read [logging.properties] from [%JRE_HOME%/lib/logging.properties] error!", new Object[0]);
            }
        }
        finally {
            IoUtils.close(in);
        }
    }
}

