/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.bridge;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.office.bridge.OnlineOfficeBridgeFactory;
import org.aoju.bus.office.bridge.OnlineOfficeEntryBuilder;
import org.aoju.bus.office.builtin.MadeInOffice;
import org.aoju.bus.office.metric.AbstractOfficeEntryManager;
import org.aoju.bus.office.metric.RequestBuilder;

public class OnlineOfficeEntryManager
extends AbstractOfficeEntryManager {
    private final String connectionUrl;

    public OnlineOfficeEntryManager(String connectionUrl, OnlineOfficeEntryBuilder config) {
        super(config);
        this.connectionUrl = connectionUrl;
    }

    private static File getFile(URL url) {
        try {
            return new File(new URI(StringUtils.replace(url.toString(), " ", "%20")).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(url.getFile());
        }
    }

    private static File getFile(String resourceLocation) throws FileNotFoundException {
        Assert.notNull(resourceLocation, "Resource location must not be null", new Object[0]);
        if (resourceLocation.startsWith("classpath:")) {
            URL url;
            String path = resourceLocation.substring("classpath:".length());
            String description = "class path resource [" + path + "]";
            ClassLoader cl = ClassUtils.getDefaultClassLoader();
            URL uRL = url = cl != null ? cl.getResource(path) : ClassLoader.getSystemResource(path);
            if (url == null) {
                throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not exist");
            }
            return OnlineOfficeEntryManager.getFile(url.toString());
        }
        try {
            return OnlineOfficeEntryManager.getFile(new URL(resourceLocation));
        }
        catch (MalformedURLException ex) {
            return new File(resourceLocation);
        }
    }

    private static SSLSocketFactory createTrustAllSSLFactory(X509TrustManager X509TrustManager2) {
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{X509TrustManager2}, new SecureRandom());
            return sc.getSocketFactory();
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return null;
        }
    }

    private static HostnameVerifier createTrustAllHostnameVerifier() {
        return (hostname, session) -> true;
    }

    private String buildUrl(String connectionUrl) throws MalformedURLException {
        URL url = new URL(connectionUrl);
        String path = url.toExternalForm().toLowerCase();
        if (StringUtils.endsWithAny(path, "lool/convert-to", "lool/convert-to/")) {
            return StringUtils.appendIfMissing(connectionUrl, (CharSequence)"/", new CharSequence[0]);
        }
        if (StringUtils.endsWithAny(path, "lool", "lool/")) {
            return StringUtils.appendIfMissing(connectionUrl, (CharSequence)"/", new CharSequence[0]) + "convert-to/";
        }
        return StringUtils.appendIfMissing(connectionUrl, (CharSequence)"/", new CharSequence[0]) + "lool/convert-to/";
    }

    @Override
    protected void doExecute(MadeInOffice task) throws InstrumentException {
        try {
            RequestBuilder requestBuilder = new RequestBuilder(this.buildUrl(this.connectionUrl), Math.toIntExact(this.config.getTaskExecutionTimeout()), Math.toIntExact(this.config.getTaskExecutionTimeout()));
            task.execute(new OnlineOfficeBridgeFactory(new Httpx(), requestBuilder));
        }
        catch (IOException ex) {
            throw new InstrumentException("Unable to create the HTTP client", ex);
        }
    }

    @Override
    protected void doStart() throws InstrumentException {
        this.taskExecutor.setAvailable(true);
    }

    @Override
    protected void doStop() throws InstrumentException {
    }

    private KeyStore loadStore(String store, String storePassword, String storeType, String storeProvider) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, NoSuchProviderException {
        if (store != null) {
            Assert.notNull(storePassword, "The password of store {0} must not be null", store);
            String type = storeType == null ? KeyStore.getDefaultType() : storeType;
            KeyStore keyStore = storeProvider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, storeProvider);
            try (FileInputStream instream = new FileInputStream(OnlineOfficeEntryManager.getFile(store));){
                keyStore.load(instream, storePassword.toCharArray());
            }
            return keyStore;
        }
        return null;
    }

    private static class X509TrustManager
    implements javax.net.ssl.X509TrustManager {
        private X509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

