/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.UriUtils;

public class GroupedSet
extends HashMap<String, LinkedHashSet<String>> {
    private static final String COMMENT_FLAG_PRE = "#";
    private static final char[] GROUP_SURROUND = new char[]{'[', ']'};
    private java.nio.charset.Charset charset;
    private URL groupedSetUrl;

    public GroupedSet(java.nio.charset.Charset charset) {
        this.charset = charset;
    }

    public GroupedSet(String pathBaseClassLoader, java.nio.charset.Charset charset) {
        URL url;
        if (null == pathBaseClassLoader) {
            pathBaseClassLoader = "";
        }
        if ((url = UriUtils.getURL(pathBaseClassLoader)) == null) {
            throw new RuntimeException(StringUtils.format("Can not find GroupSet file : [{}]", pathBaseClassLoader));
        }
        this.init(url, charset);
    }

    public GroupedSet(File configFile, java.nio.charset.Charset charset) {
        if (configFile == null) {
            throw new RuntimeException("Null GroupSet file!");
        }
        URL url = UriUtils.getURL(configFile);
        if (url == null) {
            throw new RuntimeException(StringUtils.format("Can not find GroupSet file : [{}]", configFile.getAbsolutePath()));
        }
        this.init(url, charset);
    }

    public GroupedSet(String path, Class<?> clazz, java.nio.charset.Charset charset) {
        URL url = UriUtils.getURL(path, clazz);
        if (url == null) {
            throw new RuntimeException(StringUtils.format("Can not find GroupSet file : [{}]", path));
        }
        this.init(url, charset);
    }

    public GroupedSet(URL url, java.nio.charset.Charset charset) {
        if (url == null) {
            throw new RuntimeException("Null url define!");
        }
        this.init(url, charset);
    }

    public GroupedSet(String pathBaseClassLoader) {
        this(pathBaseClassLoader, Charset.UTF_8);
    }

    public boolean init(URL groupedSetUrl, java.nio.charset.Charset charset) {
        if (groupedSetUrl == null) {
            throw new RuntimeException("Null GroupSet url or charset define!");
        }
        this.charset = charset;
        this.groupedSetUrl = groupedSetUrl;
        return this.load(groupedSetUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean load(URL groupedSetUrl) {
        if (groupedSetUrl == null) {
            throw new RuntimeException("Null GroupSet url define!");
        }
        InputStream settingStream = null;
        try {
            settingStream = groupedSetUrl.openStream();
            this.load(settingStream);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            IoUtils.close(settingStream);
        }
        return true;
    }

    public void reload() {
        this.load(this.groupedSetUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(InputStream settingStream) throws IOException {
        super.clear();
        BufferedReader reader = null;
        try {
            String line;
            reader = IoUtils.getReader(settingStream, this.charset);
            LinkedHashSet<String> valueSet = null;
            while ((line = reader.readLine()) != null) {
                if (StringUtils.isBlank(line = line.trim()) || line.startsWith(COMMENT_FLAG_PRE)) continue;
                if (line.startsWith("\\#")) {
                    line = line.substring(1);
                }
                if (line.charAt(0) == GROUP_SURROUND[0] && line.charAt(line.length() - 1) == GROUP_SURROUND[1]) {
                    String group = line.substring(1, line.length() - 1).trim();
                    valueSet = (LinkedHashSet<String>)super.get(group);
                    if (null == valueSet) {
                        valueSet = new LinkedHashSet<String>();
                    }
                    super.put(group, valueSet);
                    continue;
                }
                if (null == valueSet) {
                    valueSet = new LinkedHashSet<String>();
                    super.put("", valueSet);
                }
                valueSet.add(line);
            }
        }
        catch (Throwable throwable) {
            IoUtils.close(reader);
            throw throwable;
        }
        IoUtils.close(reader);
        return true;
    }

    public String getPath() {
        return this.groupedSetUrl.getPath();
    }

    public Set<String> getGroups() {
        return super.keySet();
    }

    public LinkedHashSet<String> getValues(String group) {
        if (group == null) {
            group = "";
        }
        return (LinkedHashSet)super.get(group);
    }

    public boolean contains(String group, String value, String ... otherValues) {
        if (ArrayUtils.isNotEmpty(otherValues)) {
            List<String> valueList = Arrays.asList(otherValues);
            valueList.add(value);
            return this.contains(group, valueList);
        }
        LinkedHashSet<String> valueSet = this.getValues(group);
        if (CollUtils.isEmpty(valueSet)) {
            return false;
        }
        return valueSet.contains(value);
    }

    public boolean contains(String group, Collection<String> values) {
        LinkedHashSet<String> valueSet = this.getValues(group);
        if (CollUtils.isEmpty(values) || CollUtils.isEmpty(valueSet)) {
            return false;
        }
        return valueSet.containsAll(values);
    }
}

