/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.UpYun;
import com.upyun.UpException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.storage.Builder;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Message;
import org.aoju.bus.storage.provider.AbstractProvider;

public class UpaiYunOssProvider
extends AbstractProvider {
    private UpYun client;

    public UpaiYunOssProvider(Context context) {
        this.context = context;
        Assert.notBlank(this.context.getPrefix(), "[prefix] not defined", new Object[0]);
        Assert.notBlank(this.context.getEndpoint(), "[endpoint] not defined", new Object[0]);
        Assert.notBlank(this.context.getBucket(), "[bucket] not defined", new Object[0]);
        Assert.notBlank(this.context.getAccessKey(), "[accessKey] not defined", new Object[0]);
        Assert.notBlank(this.context.getSecretKey(), "[secure] not defined", new Object[0]);
        this.client = new UpYun(this.context.getBucket(), this.context.getAccessKey(), this.context.getSecretKey());
    }

    @Override
    public Message download(String fileName) {
        return this.download(this.context.getBucket(), fileName);
    }

    @Override
    public Message download(String bucket, String fileName) {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message download(String fileName, File file) {
        try {
            this.client.writeFile(fileName, file);
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).build();
        }
        catch (UpException | IOException e) {
            Logger.error("file download failed" + e.getMessage(), new Object[0]);
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
    }

    @Override
    public Message download(String bucket, String fileName, File file) {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message list() {
        try {
            List list = this.client.readDir(this.context.getPrefix());
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).data(list.stream().map(item -> {
                Attachs storageItem = new Attachs();
                storageItem.setName(item.name);
                storageItem.setType(item.type);
                storageItem.setSize(StringUtils.toString(item.size));
                return storageItem;
            }).collect(Collectors.toList())).build();
        }
        catch (UpException | IOException e) {
            Logger.error("file list failed" + e.getMessage(), new Object[0]);
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
    }

    @Override
    public Message rename(String oldName, String newName) {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message rename(String bucket, String oldName, String newName) {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message upload(String fileName, byte[] content) {
        return this.upload(this.context.getBucket(), fileName, content);
    }

    @Override
    public Message upload(String bucket, String fileName, InputStream content) {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message upload(String bucket, String fileName, byte[] content) {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message remove(String fileName) {
        try {
            this.client.deleteFile('/' + fileName);
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).build();
        }
        catch (UpException | IOException e) {
            Logger.error("file remove failed", e.getMessage());
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
    }

    @Override
    public Message remove(String bucket, String fileName) {
        return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
    }

    @Override
    public Message remove(String bucket, Path path) {
        return this.remove(bucket, path.toString());
    }
}

