/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.base.entity;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.aoju.bus.base.entity.BaseEntity;

public class Result<T>
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int total;
    protected List<T> rows;

    public Result() {
    }

    public Result(int total, List<T> rows) {
        this.total = total;
        this.rows = rows;
    }

    public Result(List<T> rows, int pageSize) {
        if (rows == null || rows.isEmpty()) {
            throw new IllegalArgumentException("data must be not empty!");
        }
        new Result<T>(rows, rows.size(), pageSize);
    }

    public Result(List<T> rows, int total, int pageSize) {
        this.total = total;
        this.pageSize = pageSize;
        this.rows = rows;
    }

    public static <T> Result<T> Result(List<T> rows, int pageSize) {
        return new Result<T>(rows, pageSize);
    }

    public List<T> get(int pageNo) {
        int fromIndex = (pageNo - 1) * this.pageSize;
        if (fromIndex >= this.rows.size()) {
            return Collections.emptyList();
        }
        int toIndex = pageNo * this.pageSize;
        if (toIndex >= this.rows.size()) {
            toIndex = this.rows.size();
        }
        return this.rows.subList(fromIndex, toIndex);
    }

    public int getTotal() {
        return this.total;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    @Override
    public String toString() {
        return "Result(total=" + this.getTotal() + ", rows=" + this.getRows() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        List<T> this$rows = this.getRows();
        List<T> other$rows = other.getRows();
        return !(this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTotal();
        List<T> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        return result;
    }
}

