/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans.copier.provider;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.aoju.bus.core.beans.BeanDesc;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.StringUtils;

public class BeanValueProvider
implements ValueProvider<String> {
    final Map<String, BeanDesc.PropDesc> sourcePdMap;
    private Object source;
    private boolean ignoreError;

    public BeanValueProvider(Object bean, boolean ignoreCase, boolean ignoreError) {
        this.source = bean;
        this.ignoreError = ignoreError;
        this.sourcePdMap = BeanUtils.getBeanDesc(this.source.getClass()).getPropMap(ignoreCase);
    }

    @Override
    public Object value(String key, Type valueType) {
        Method getter;
        BeanDesc.PropDesc sourcePd = this.sourcePdMap.get(key);
        if (null == sourcePd && (Boolean.class == valueType || Boolean.TYPE == valueType)) {
            sourcePd = this.sourcePdMap.get(StringUtils.upperFirstAndAddPre(key, "is"));
        }
        Object result = null;
        if (null != sourcePd && null != (getter = sourcePd.getGetter())) {
            block4: {
                try {
                    result = getter.invoke(this.source, new Object[0]);
                }
                catch (Exception e) {
                    if (this.ignoreError) break block4;
                    throw new InstrumentException("Inject [{}] error!", key);
                }
            }
            result = Convert.convertWithCheck(valueType, result, null, this.ignoreError);
        }
        return result;
    }

    @Override
    public boolean containsKey(String key) {
        return this.sourcePdMap.containsKey(key) || this.sourcePdMap.containsKey(StringUtils.upperFirstAndAddPre(key, "is"));
    }
}

