/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.codec;

import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.utils.StringUtils;

public final class Base32 {
    public static String encode(byte[] bytes) {
        int i = 0;
        int index = 0;
        StringBuilder base32 = new StringBuilder((bytes.length + 7) * 8 / 5);
        while (i < bytes.length) {
            int digit;
            int currByte;
            int n = currByte = bytes[i] >= 0 ? bytes[i] : bytes[i] + 256;
            if (index > 3) {
                int nextByte = i + 1 < bytes.length ? (bytes[i + 1] >= 0 ? bytes[i + 1] : bytes[i + 1] + 256) : 0;
                digit = currByte & 255 >> index;
                index = (index + 5) % 8;
                digit <<= index;
                digit |= nextByte >> 8 - index;
                ++i;
            } else {
                digit = currByte >> 8 - (index + 5) & 0x1F;
                if ((index = (index + 5) % 8) == 0) {
                    ++i;
                }
            }
            base32.append(Normal.ENCODE_32_TABLE[digit]);
        }
        return base32.toString();
    }

    public static String encode(String source) {
        return Base32.encode(source, Charset.UTF_8);
    }

    public static String encode(String source, String charset) {
        return Base32.encode(StringUtils.bytes((CharSequence)source, charset));
    }

    public static String encode(String source, java.nio.charset.Charset charset) {
        return Base32.encode(StringUtils.bytes((CharSequence)source, charset));
    }

    public static byte[] decode(String base32) {
        byte[] bytes = new byte[base32.length() * 5 / 8];
        int index = 0;
        int offset = 0;
        for (int i = 0; i < base32.length(); ++i) {
            int digit;
            int lookup = base32.charAt(i) - 48;
            if (lookup < 0 || lookup >= Normal.DECODE_32_TABLE.length || (digit = Normal.DECODE_32_TABLE[lookup]) == 255) continue;
            if (index <= 3) {
                if ((index = (index + 5) % 8) == 0) {
                    int n = offset++;
                    bytes[n] = (byte)(bytes[n] | digit);
                    if (offset < bytes.length) continue;
                    break;
                }
                int n = offset;
                bytes[n] = (byte)(bytes[n] | digit << 8 - index);
                continue;
            }
            index = (index + 5) % 8;
            int n = offset++;
            bytes[n] = (byte)(bytes[n] | digit >>> index);
            if (offset >= bytes.length) break;
            int n2 = offset;
            bytes[n2] = (byte)(bytes[n2] | digit << 8 - index);
        }
        return bytes;
    }

    public static String decodeStr(String source) {
        return Base32.decodeStr(source, Charset.UTF_8);
    }

    public static String decodeStr(String source, String charset) {
        return StringUtils.toString(Base32.decode(source), charset);
    }

    public static String decodeStr(String source, java.nio.charset.Charset charset) {
        return StringUtils.toString(Base32.decode(source), charset);
    }
}

