/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.aoju.bus.gitlab.AbstractApi;
import org.aoju.bus.gitlab.Constants;
import org.aoju.bus.gitlab.GitLabApi;
import org.aoju.bus.gitlab.GitLabApiException;
import org.aoju.bus.gitlab.GitLabApiForm;
import org.aoju.bus.gitlab.models.RepositoryFile;

public class RepositoryFileApi
extends AbstractApi {
    public RepositoryFileApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public Optional<RepositoryFile> getOptionalFileInfo(Object projectIdOrPath, String filePath, String ref) {
        try {
            return Optional.ofNullable(this.getFileInfo(projectIdOrPath, filePath, ref));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public RepositoryFile getFileInfo(Object projectIdOrPath, String filePath, String ref) throws GitLabApiException {
        Form form = new Form();
        this.addFormParam(form, "ref", ref, true);
        Response response = this.head(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(filePath));
        RepositoryFile file = new RepositoryFile();
        file.setBlobId(response.getHeaderString("X-Gitlab-Blob-Id"));
        file.setCommitId(response.getHeaderString("X-Gitlab-Commit-Id"));
        String encoding = response.getHeaderString("X-Gitlab-Encoding");
        file.setEncoding(Constants.Encoding.forValue(encoding));
        file.setFileName(response.getHeaderString("X-Gitlab-File-Name"));
        file.setFilePath(response.getHeaderString("X-Gitlab-File-Path"));
        file.setLastCommitId(response.getHeaderString("X-Gitlab-Last-Commit-Id"));
        file.setRef(response.getHeaderString("X-Gitlab-Ref"));
        String sizeStr = response.getHeaderString("X-Gitlab-Size");
        file.setSize(sizeStr != null ? Integer.valueOf(sizeStr) : -1);
        return file;
    }

    public Optional<RepositoryFile> getOptionalFile(Object projectIdOrPath, String filePath, String ref) {
        try {
            return Optional.ofNullable(this.getFile(projectIdOrPath, filePath, ref, true));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public RepositoryFile getFile(Object projectIdOrPath, String filePath, String ref) throws GitLabApiException {
        return this.getFile(projectIdOrPath, filePath, ref, true);
    }

    public RepositoryFile getFile(Object projectIdOrPath, String filePath, String ref, boolean includeContent) throws GitLabApiException {
        if (!includeContent) {
            return this.getFileInfo(projectIdOrPath, filePath, ref);
        }
        Form form = new Form();
        this.addFormParam(form, "ref", ref, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(filePath));
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    public RepositoryFile createFile(Object projectIdOrPath, RepositoryFile file, String branchName, String commitMessage) throws GitLabApiException {
        Form formData = this.createForm(file, branchName, commitMessage);
        Response response = this.isApiVersion(GitLabApi.ApiVersion.V3) ? this.post(Response.Status.CREATED, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files"}) : this.post(Response.Status.CREATED, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(file.getFilePath())});
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    public RepositoryFile updateFile(Object projectIdOrPath, RepositoryFile file, String branchName, String commitMessage) throws GitLabApiException {
        Form formData = this.createForm(file, branchName, commitMessage);
        Response response = this.isApiVersion(GitLabApi.ApiVersion.V3) ? this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files") : this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(file.getFilePath()));
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    public void deleteFile(Object projectIdOrPath, String filePath, String branchName, String commitMessage) throws GitLabApiException {
        Response.Status expectedStatus;
        if (filePath == null) {
            throw new RuntimeException("filePath cannot be null");
        }
        Form form = new Form();
        this.addFormParam(form, this.isApiVersion(GitLabApi.ApiVersion.V3) ? "branch_name" : "branch", branchName, true);
        this.addFormParam(form, "commit_message", commitMessage, true);
        Response.Status status = expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            this.addFormParam(form, "file_path", filePath, true);
            this.delete(expectedStatus, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files");
        } else {
            this.delete(expectedStatus, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(filePath));
        }
    }

    public File getRawFile(Object projectIdOrPath, String commitOrBranchName, String filepath, File directory) throws GitLabApiException {
        InputStream in = this.getRawFile(projectIdOrPath, commitOrBranchName, filepath);
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = new File(filepath).getName();
            File file = new File(directory, filename);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File file2 = file;
            return file2;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public InputStream getRawFile(Object projectIdOrPath, String commitOrBranchName, String filepath) throws GitLabApiException {
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            GitLabApiForm formData = new GitLabApiForm().withParam("file_path", filepath, true);
            Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "blobs", commitOrBranchName);
            return (InputStream)response.readEntity(InputStream.class);
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("ref", commitOrBranchName, true);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(filepath), "raw");
        return (InputStream)response.readEntity(InputStream.class);
    }

    protected Form createForm(RepositoryFile file, String branchName, String commitMessage) {
        Form form = new Form();
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            this.addFormParam(form, "file_path", file.getFilePath(), true);
            this.addFormParam(form, "branch_name", branchName, true);
        } else {
            this.addFormParam(form, "branch", branchName, true);
        }
        this.addFormParam(form, "encoding", (Object)file.getEncoding(), false);
        String content = file.getContent();
        if (content == null) {
            throw new IllegalArgumentException("content cannot be null");
        }
        form.param("content", content);
        this.addFormParam(form, "commit_message", commitMessage, true);
        return form;
    }
}

