/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractComputerSystem;
import org.aoju.bus.health.builtin.hardware.Baseboard;
import org.aoju.bus.health.builtin.hardware.Firmware;
import org.aoju.bus.health.linux.ProcPath;
import org.aoju.bus.health.linux.hardware.LinuxBaseboard;
import org.aoju.bus.health.linux.hardware.LinuxFirmware;

@Immutable
final class LinuxComputerSystem
extends AbstractComputerSystem {
    private final Supplier<String> manufacturer = Memoize.memoize(LinuxComputerSystem::queryManufacturer);
    private final Supplier<String> model = Memoize.memoize(LinuxComputerSystem::queryModel);
    private final Supplier<String> serialNumber = Memoize.memoize(LinuxComputerSystem::querySerialNumber);

    LinuxComputerSystem() {
    }

    private static String queryManufacturer() {
        String result = null;
        result = LinuxComputerSystem.queryManufacturerFromSysfs();
        if (result == null && (result = LinuxComputerSystem.queryManufacturerFromProcCpu()) == null) {
            return "unknown";
        }
        return result;
    }

    private static String queryModel() {
        String result = null;
        result = LinuxComputerSystem.queryModelFromSysfs();
        if (result == null && (result = LinuxComputerSystem.queryModelFromDeviceTree()) == null && (result = LinuxComputerSystem.queryModelFromLshw()) == null) {
            return "unknown";
        }
        return result;
    }

    private static String querySerialNumber() {
        String result = null;
        result = LinuxComputerSystem.querySerialFromSysfs();
        if (result == null && (result = LinuxComputerSystem.querySerialFromDmiDecode()) == null && (result = LinuxComputerSystem.querySerialFromLshal()) == null && (result = LinuxComputerSystem.querySerialFromLshw()) == null) {
            return "unknown";
        }
        return result;
    }

    private static String queryManufacturerFromSysfs() {
        String sysVendor = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/sys_vendor").trim();
        if (!sysVendor.isEmpty()) {
            return sysVendor;
        }
        return null;
    }

    private static String queryManufacturerFromProcCpu() {
        List<String> cpuInfo = Builder.readFile(ProcPath.CPUINFO);
        for (String line : cpuInfo) {
            if (!line.startsWith("CPU implementer")) continue;
            int part = Builder.parseLastInt(line, 0);
            switch (part) {
                case 65: {
                    return "ARM";
                }
                case 66: {
                    return "Broadcom";
                }
                case 67: {
                    return "Cavium";
                }
                case 68: {
                    return "DEC";
                }
                case 78: {
                    return "Nvidia";
                }
                case 80: {
                    return "APM";
                }
                case 81: {
                    return "Qualcomm";
                }
                case 83: {
                    return "Samsung";
                }
                case 86: {
                    return "Marvell";
                }
                case 102: {
                    return "Faraday";
                }
                case 105: {
                    return "Intel";
                }
            }
            return null;
        }
        return null;
    }

    private static String queryModelFromSysfs() {
        String productName = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/product_name").trim();
        String productVersion = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/product_version").trim();
        if (productName.isEmpty()) {
            if (!productVersion.isEmpty()) {
                return productVersion;
            }
        } else {
            if (!productVersion.isEmpty() && !"None".equals(productVersion)) {
                return productName + " (version: " + productVersion + ")";
            }
            return productName;
        }
        return null;
    }

    private static String queryModelFromDeviceTree() {
        String modelStr = Builder.getStringFromFile("/sys/firmware/devicetree/base/model");
        if (!modelStr.isEmpty()) {
            return modelStr.replace("Machine: ", "");
        }
        return null;
    }

    private static String queryModelFromLshw() {
        String modelMarker = "product:";
        for (String checkLine : Executor.runNative("lshw -C system")) {
            if (!checkLine.contains(modelMarker)) continue;
            return checkLine.split(modelMarker)[1].trim();
        }
        return null;
    }

    private static String querySerialFromSysfs() {
        String serial = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/product_serial");
        if (serial.isEmpty() || "None".equals(serial)) {
            serial = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/board_serial");
            if (serial.isEmpty() || "None".equals(serial)) {
                return null;
            }
            return serial;
        }
        return null;
    }

    private static String querySerialFromDmiDecode() {
        String marker = "Serial Number:";
        for (String checkLine : Executor.runNative("dmidecode -t system")) {
            if (!checkLine.contains(marker)) continue;
            return checkLine.split(marker)[1].trim();
        }
        return null;
    }

    private static String querySerialFromLshal() {
        String marker = "system.hardware.serial =";
        for (String checkLine : Executor.runNative("lshal")) {
            if (!checkLine.contains(marker)) continue;
            return Builder.getSingleQuoteStringValue(checkLine);
        }
        return null;
    }

    private static String querySerialFromLshw() {
        String serialMarker = "serial:";
        for (String checkLine : Executor.runNative("lshw -C system")) {
            if (!checkLine.contains(serialMarker)) continue;
            return checkLine.split(serialMarker)[1].trim();
        }
        return null;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer.get();
    }

    @Override
    public String getModel() {
        return this.model.get();
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber.get();
    }

    @Override
    public Firmware createFirmware() {
        return new LinuxFirmware();
    }

    @Override
    public Baseboard createBaseboard() {
        return new LinuxBaseboard();
    }
}

