/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.drivers;

import com.sun.jna.platform.unix.solaris.LibKstat;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.unix.solaris.KstatCtl;

@ThreadSafe
public final class SystemPages {
    private SystemPages() {
    }

    public static Pair<Long, Long> queryAvailableTotal() {
        long memAvailable = 0L;
        long memTotal = 0L;
        try (KstatCtl.KstatChain kc = KstatCtl.openChain();){
            LibKstat.Kstat ksp = kc.lookup(null, -1, "system_pages");
            if (ksp != null && kc.read(ksp)) {
                memAvailable = KstatCtl.dataLookupLong(ksp, "availrmem");
                memTotal = KstatCtl.dataLookupLong(ksp, "physmem");
            }
        }
        return Pair.of(memAvailable, memTotal);
    }
}

