/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.drivers;

import com.sun.jna.platform.win32.VersionHelpers;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.windows.PerfCounterQuery;
import org.aoju.bus.health.windows.PerfCounterWildcardQuery;

@ThreadSafe
public final class ProcessorInformation {
    private static final String PROCESSOR = "Processor";
    private static final String INTERRUPT_COUNT = "Interrupt Count";
    private static final String PROCESSOR_FREQUENCY = "Processor Frequency";
    private static final String PROCESSOR_INFORMATION = "Processor Information";
    private static final String PROCESSOR_TICK_COUNT = "Processor Tick Count";
    private static final String WIN32_PERF_RAW_DATA_COUNTERS_PROCESSOR_INFORMATION_WHERE_NOT_NAME_LIKE_TOTAL = "Win32_PerfRawData_Counters_ProcessorInformation WHERE NOT Name LIKE\"%_Total\"";
    private static final String WIN32_PERF_RAW_DATA_PERF_OS_PROCESSOR_WHERE_NOT_NAME_TOTAL = "Win32_PerfRawData_PerfOS_Processor WHERE NOT Name=\"_Total\"";
    private static final String WIN32_PERF_RAW_DATA_PERF_OS_PROCESSOR_WHERE_NAME_TOTAL = "Win32_PerfRawData_PerfOS_Processor WHERE Name=\"_Total\"";
    private static final boolean IS_WIN7_OR_GREATER = VersionHelpers.IsWindows7OrGreater();

    private ProcessorInformation() {
    }

    public static Pair<List<String>, Map<ProcessorTickCountProperty, List<Long>>> queryProcessorCounters() {
        PerfCounterWildcardQuery<ProcessorTickCountProperty> processorTickPerfCounters = IS_WIN7_OR_GREATER ? new PerfCounterWildcardQuery<ProcessorTickCountProperty>(ProcessorTickCountProperty.class, PROCESSOR_INFORMATION, WIN32_PERF_RAW_DATA_COUNTERS_PROCESSOR_INFORMATION_WHERE_NOT_NAME_LIKE_TOTAL, PROCESSOR_TICK_COUNT) : new PerfCounterWildcardQuery<ProcessorTickCountProperty>(ProcessorTickCountProperty.class, PROCESSOR, WIN32_PERF_RAW_DATA_PERF_OS_PROCESSOR_WHERE_NOT_NAME_TOTAL, PROCESSOR_TICK_COUNT);
        Map<ProcessorTickCountProperty, List<Long>> values = processorTickPerfCounters.queryValuesWildcard();
        List<String> instances = processorTickPerfCounters.getInstancesFromLastQuery();
        return Pair.of(instances, values);
    }

    public static Map<SystemTickCountProperty, Long> querySystemCounters() {
        PerfCounterQuery<SystemTickCountProperty> systemTickPerfCounters = new PerfCounterQuery<SystemTickCountProperty>(SystemTickCountProperty.class, PROCESSOR, WIN32_PERF_RAW_DATA_PERF_OS_PROCESSOR_WHERE_NAME_TOTAL, "System Tick Count");
        return systemTickPerfCounters.queryValues();
    }

    public static Map<InterruptsProperty, Long> queryInterruptCounters() {
        PerfCounterQuery<InterruptsProperty> interruptsPerfCounters = new PerfCounterQuery<InterruptsProperty>(InterruptsProperty.class, PROCESSOR, WIN32_PERF_RAW_DATA_PERF_OS_PROCESSOR_WHERE_NAME_TOTAL, INTERRUPT_COUNT);
        return interruptsPerfCounters.queryValues();
    }

    public static Pair<List<String>, Map<ProcessorFrequencyProperty, List<Long>>> queryFrequencyCounters() {
        PerfCounterWildcardQuery<ProcessorFrequencyProperty> processorFrequencyCounters = new PerfCounterWildcardQuery<ProcessorFrequencyProperty>(ProcessorFrequencyProperty.class, PROCESSOR_INFORMATION, WIN32_PERF_RAW_DATA_COUNTERS_PROCESSOR_INFORMATION_WHERE_NOT_NAME_LIKE_TOTAL, PROCESSOR_FREQUENCY);
        Map<ProcessorFrequencyProperty, List<Long>> values = processorFrequencyCounters.queryValuesWildcard();
        List<String> instances = processorFrequencyCounters.getInstancesFromLastQuery();
        return Pair.of(instances, values);
    }

    public static enum ProcessorFrequencyProperty implements PerfCounterWildcardQuery.PdhCounterWildcardProperty
    {
        NAME("^*_Total"),
        PERCENTOFMAXIMUMFREQUENCY("% of Maximum Frequency");

        private final String counter;

        private ProcessorFrequencyProperty(String counter) {
            this.counter = counter;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }

    public static enum InterruptsProperty implements PerfCounterQuery.PdhCounterProperty
    {
        INTERRUPTSPERSEC("_Total", "Interrupts/sec");

        private final String instance;
        private final String counter;

        private InterruptsProperty(String instance, String counter) {
            this.instance = instance;
            this.counter = counter;
        }

        @Override
        public String getInstance() {
            return this.instance;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }

    public static enum SystemTickCountProperty implements PerfCounterQuery.PdhCounterProperty
    {
        PERCENTDPCTIME("_Total", "% DPC Time"),
        PERCENTINTERRUPTTIME("_Total", "% Interrupt Time");

        private final String instance;
        private final String counter;

        private SystemTickCountProperty(String instance, String counter) {
            this.instance = instance;
            this.counter = counter;
        }

        @Override
        public String getInstance() {
            return this.instance;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }

    public static enum ProcessorTickCountProperty implements PerfCounterWildcardQuery.PdhCounterWildcardProperty
    {
        NAME("^*_Total"),
        PERCENTDPCTIME("% DPC Time"),
        PERCENTINTERRUPTTIME("% Interrupt Time"),
        PERCENTPRIVILEGEDTIME("% Privileged Time"),
        PERCENTPROCESSORTIME("% Processor Time"),
        PERCENTUSERTIME("% User Time");

        private final String counter;

        private ProcessorTickCountProperty(String counter) {
            this.counter = counter;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }
}

