/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric;

import java.util.HashMap;
import org.aoju.bus.image.Editors;
import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.metric.AttributeContext;

public class DefaultEditors
implements Editors {
    private final boolean generateUIDs;
    private final Attributes tagToOverride;
    private final HashMap<String, String> uidMap;

    public DefaultEditors(Attributes tagToOverride) {
        this(false, tagToOverride);
    }

    public DefaultEditors(boolean generateUIDs, Attributes tagToOverride) {
        this.generateUIDs = generateUIDs;
        this.tagToOverride = tagToOverride;
        this.uidMap = generateUIDs ? new HashMap() : null;
    }

    @Override
    public boolean apply(Attributes data, AttributeContext context) {
        if (data != null) {
            boolean update = false;
            if (this.generateUIDs) {
                if ("2.25".equals(UID.getRoot())) {
                    UID.setRoot("2.25.35");
                }
                String oldStudyUID = data.getString(0x20000D);
                String studyUID = this.uidMap.computeIfAbsent(oldStudyUID, k -> UID.createUID());
                data.setString(0x20000D, VR.UI, studyUID);
                String oldSeriesUID = data.getString(0x20000E);
                String seriesUID = this.uidMap.computeIfAbsent(oldSeriesUID, k -> UID.createUID());
                data.setString(0x20000E, VR.UI, seriesUID);
                String iuid = UID.createUID();
                data.setString(524312, VR.UI, iuid);
                update = true;
            }
            if (this.tagToOverride != null && !this.tagToOverride.isEmpty()) {
                data.update(Attributes.UpdatePolicy.OVERWRITE, this.tagToOverride, null);
                update = true;
            }
            return update;
        }
        return false;
    }
}

