/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class KujialeProvider
extends DefaultProvider {
    public KujialeProvider(Context context) {
        super(context, Registry.KUJIALE);
    }

    public KujialeProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.KUJIALE, extendCache);
    }

    @Override
    public String authorize(String state) {
        return this.authorize(state, "get_user_info");
    }

    public String authorize(String state, String scopeStr) {
        Builder builder = Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state));
        if (StringUtils.isNotEmpty(scopeStr)) {
            builder.queryParam("scope", scopeStr);
        }
        return builder.build();
    }

    @Override
    public AccToken getAccessToken(Callback Callback2) {
        return this.getAuthToken(this.doPostAuthorizationCode(Callback2.getCode()));
    }

    private AccToken getAuthToken(String response) {
        JSONObject object = this.checkResponse(response);
        JSONObject resultObject = object.getJSONObject("d");
        return AccToken.builder().accessToken(resultObject.getString("accessToken")).refreshToken(resultObject.getString("refreshToken")).expireIn(resultObject.getIntValue("expiresIn")).build();
    }

    private JSONObject checkResponse(String response) {
        JSONObject object = JSONObject.parseObject((String)response);
        if (!"0".equals(object.getString("c"))) {
            throw new AuthorizedException(object.getString("m"));
        }
        return object;
    }

    @Override
    public Property getUserInfo(AccToken token) {
        String openId = this.getOpenId(token);
        String response = Httpx.get(Builder.fromUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).queryParam("open_id", openId).build());
        JSONObject object = JSONObject.parseObject((String)response);
        if (!"0".equals(object.getString("c"))) {
            throw new AuthorizedException(object.getString("m"));
        }
        JSONObject resultObject = object.getJSONObject("d");
        return Property.builder().username(resultObject.getString("userName")).nickname(resultObject.getString("userName")).avatar(resultObject.getString("avatar")).uuid(resultObject.getString("openId")).token(token).source(this.source.toString()).build();
    }

    private String getOpenId(AccToken token) {
        String response = Httpx.get(Builder.fromUrl("https://oauth.kujiale.com/oauth2/auth/user").queryParam("access_token", token.getAccessToken()).build());
        JSONObject accessTokenObject = this.checkResponse(response);
        return accessTokenObject.getString("d");
    }

    @Override
    public Message refresh(AccToken token) {
        String response = Httpx.post(this.refreshTokenUrl(token.getRefreshToken()));
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(this.getAuthToken(response)).build();
    }
}

