/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic.family;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.aoju.bus.core.builder.ToStringBuilder;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.office.magic.family.FamilyType;

public class DocumentFormat {
    public String name;
    public List<String> extensions;
    public String mediaType;
    public FamilyType inputFamily;
    public Map<String, Object> loadProperties;
    public Map<FamilyType, Map<String, Object>> storeProperties;

    public DocumentFormat() {
    }

    private DocumentFormat(String name, Collection<String> extensions, String mediaType, FamilyType inputFamily, Map<String, Object> loadProperties, Map<FamilyType, Map<String, Object>> storeProperties, boolean unmodifiable) {
        this.name = name;
        this.extensions = new ArrayList<String>(extensions);
        this.mediaType = mediaType;
        this.inputFamily = inputFamily;
        this.loadProperties = Optional.ofNullable(loadProperties).map(HashMap::new).map(mapCopy -> unmodifiable ? Collections.unmodifiableMap(mapCopy) : mapCopy).orElse(null);
        this.storeProperties = Optional.ofNullable(storeProperties).map(map -> {
            EnumMap familyMap = new EnumMap(FamilyType.class);
            map.forEach((family, propMap) -> {
                Map cfr_ignored_0 = familyMap.put((FamilyType)((Object)((Object)family)), unmodifiable ? Collections.unmodifiableMap(new HashMap(propMap)) : new HashMap(propMap));
            });
            return familyMap;
        }).map(mapCopy -> unmodifiable ? Collections.unmodifiableMap(mapCopy) : mapCopy).orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DocumentFormat copy(DocumentFormat sourceFormat) {
        return new Builder().from(sourceFormat).unmodifiable(false).build();
    }

    public static DocumentFormat unmodifiableCopy(DocumentFormat sourceFormat) {
        return new Builder().from(sourceFormat).unmodifiable(true).build();
    }

    public String getExtension() {
        return this.extensions.get(0);
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public FamilyType getInputFamily() {
        return this.inputFamily;
    }

    public Map<String, Object> getLoadProperties() {
        return this.loadProperties;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getName() {
        return this.name;
    }

    public Map<FamilyType, Map<String, Object>> getStoreProperties() {
        return this.storeProperties;
    }

    public Map<String, Object> getStoreProperties(FamilyType family) {
        return this.storeProperties == null ? null : this.storeProperties.get((Object)family);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public static final class Builder {
        private String name;
        private Set<String> extensions;
        private String mediaType;
        private FamilyType inputFamily;
        private Map<String, Object> loadProperties;
        private Map<FamilyType, Map<String, Object>> storeProperties;
        private boolean unmodifiable = true;

        private Builder() {
        }

        public DocumentFormat build() {
            return new DocumentFormat(this.name, this.extensions, this.mediaType, this.inputFamily, this.loadProperties, this.storeProperties, this.unmodifiable);
        }

        public Builder from(DocumentFormat sourceFormat) {
            this.name = sourceFormat.getName();
            this.extensions = new LinkedHashSet<String>(sourceFormat.getExtensions());
            this.mediaType = sourceFormat.getMediaType();
            this.inputFamily = sourceFormat.getInputFamily();
            this.loadProperties = Optional.ofNullable(sourceFormat.getLoadProperties()).map(map -> map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElse(null);
            this.storeProperties = Optional.ofNullable(sourceFormat.getStoreProperties()).map(map -> {
                EnumMap familyMap = new EnumMap(FamilyType.class);
                map.forEach((family, propMap) -> {
                    Map cfr_ignored_0 = familyMap.put((FamilyType)((Object)((Object)family)), new HashMap(propMap));
                });
                return familyMap;
            }).orElse(null);
            return this;
        }

        public Builder extension(String extension) {
            if (CollUtils.isEmpty(this.extensions)) {
                this.extensions = new LinkedHashSet<String>();
            }
            this.extensions.add(extension);
            return this;
        }

        public Builder inputFamily(FamilyType inputFamily) {
            this.inputFamily = inputFamily;
            return this;
        }

        public Builder loadProperty(String name, Object value) {
            if (ObjectUtils.isEmpty(value)) {
                Optional.ofNullable(this.loadProperties).ifPresent(propMap -> propMap.remove(name));
            } else {
                if (ObjectUtils.isEmpty(this.loadProperties)) {
                    this.loadProperties = new HashMap<String, Object>();
                }
                this.loadProperties.put(name, value);
            }
            return this;
        }

        public Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder unmodifiable(boolean unmodifiable) {
            this.unmodifiable = unmodifiable;
            return this;
        }

        public Builder storeProperty(FamilyType family, String name, Object value) {
            if (value == null) {
                Optional.ofNullable(this.storeProperties).map(familyMap -> (Map)familyMap.get((Object)family)).ifPresent(propMap -> propMap.remove(name));
            } else {
                if (this.storeProperties == null) {
                    this.storeProperties = new EnumMap<FamilyType, Map<String, Object>>(FamilyType.class);
                }
                this.storeProperties.computeIfAbsent(family, key -> new HashMap()).put(name, value);
            }
            return this;
        }
    }
}

