/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.cache;

import org.aoju.bus.cache.Context;
import org.aoju.bus.cache.provider.H2Shooting;
import org.aoju.bus.cache.provider.MemoryShooting;
import org.aoju.bus.cache.provider.MySQLShooting;
import org.aoju.bus.cache.provider.SqliteShooting;
import org.aoju.bus.cache.provider.ZKShooting;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.starter.cache.AspectjCacheProxy;
import org.aoju.bus.starter.cache.CacheProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheConfiguration {
    @Autowired
    CacheProperties properties;

    @Bean
    public AspectjCacheProxy cacheConfigurer() {
        String type = StringUtils.toString(this.properties.getType());
        try {
            if (!StringUtils.isEmpty(type)) {
                Class provider = ClassUtils.loadClass(type);
                Context config = Context.newConfig(this.properties.getMap());
                if (provider instanceof H2Shooting) {
                    config.setShooting(new H2Shooting(this.properties.getProvider().getUrl(), this.properties.getProvider().getUsername(), this.properties.getProvider().getPassword()));
                } else if (provider instanceof MySQLShooting) {
                    config.setShooting(new MySQLShooting(BeanUtils.beanToMap(this.properties)));
                } else if (provider instanceof SqliteShooting) {
                    config.setShooting(new SqliteShooting(this.properties.getProvider().getUrl(), this.properties.getProvider().getUsername(), this.properties.getProvider().getPassword()));
                } else if (provider instanceof ZKShooting) {
                    config.setShooting(new ZKShooting(this.properties.getProvider().getUrl()));
                } else if (provider instanceof MemoryShooting) {
                    config.setShooting(new MemoryShooting());
                }
                return new AspectjCacheProxy(config);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can not resolve class with type: " + type);
        }
        return null;
    }
}

