/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.captcha.provider;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.ImageUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.extra.captcha.CaptchaProvider;
import org.aoju.bus.extra.captcha.strategy.CodeStrategy;
import org.aoju.bus.extra.captcha.strategy.RandomStrategy;

public abstract class AbstractProvider
implements CaptchaProvider {
    protected int width;
    protected int height;
    protected int interfereCount;
    protected Font font;
    protected String code;
    protected byte[] imageBytes;
    protected CodeStrategy generator;
    protected Color background;
    protected AlphaComposite textAlpha;

    public AbstractProvider(int width, int height, int codeCount, int interfereCount) {
        this(width, height, new RandomStrategy(codeCount), interfereCount);
    }

    public AbstractProvider(int width, int height, CodeStrategy generator, int interfereCount) {
        this.width = width;
        this.height = height;
        this.generator = generator;
        this.interfereCount = interfereCount;
        this.font = new Font("SansSerif", 0, (int)((double)this.height * 0.75));
    }

    @Override
    public void create() {
        this.generateCode();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtils.writePng(this.createImage(this.code), out);
        this.imageBytes = out.toByteArray();
    }

    protected void generateCode() {
        this.code = this.generator.generate();
    }

    protected abstract Image createImage(String var1);

    @Override
    public String get() {
        if (null == this.code) {
            this.create();
        }
        return this.code;
    }

    @Override
    public boolean verify(String inputCode) {
        return this.generator.verify(this.get(), inputCode);
    }

    public void write(String path) throws InstrumentException {
        this.write(FileUtils.touch(path));
    }

    public void write(File file) throws InstrumentException {
        try (BufferedOutputStream out = FileUtils.getOutputStream(file);){
            this.write(out);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    @Override
    public void write(OutputStream out) {
        IoUtils.write(out, false, this.getImageBytes());
    }

    public byte[] getImageBytes() {
        if (null == this.imageBytes) {
            this.create();
        }
        return this.imageBytes;
    }

    public BufferedImage getImage() {
        return ImageUtils.read(IoUtils.toStream(this.getImageBytes()));
    }

    public String getImageBase64() {
        return Base64.encode(this.getImageBytes());
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public CodeStrategy getGenerator() {
        return this.generator;
    }

    public void setGenerator(CodeStrategy generator) {
        this.generator = generator;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void setTextAlpha(float textAlpha) {
        this.textAlpha = AlphaComposite.getInstance(3, textAlpha);
    }
}

