/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.captcha.provider;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.aoju.bus.core.image.Graphics;
import org.aoju.bus.core.utils.ImageUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.RandomUtils;
import org.aoju.bus.extra.captcha.provider.AbstractProvider;

public class ShearProvider
extends AbstractProvider {
    public ShearProvider(int width, int height) {
        this(width, height, 5);
    }

    public ShearProvider(int width, int height, int codeCount) {
        this(width, height, codeCount, 4);
    }

    public ShearProvider(int width, int height, int codeCount, int thickness) {
        super(width, height, codeCount, thickness);
    }

    @Override
    public Image createImage(String code) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = Graphics.createGraphics(image, ObjectUtils.defaultIfNull(this.background, Color.WHITE));
        this.drawString(g, code);
        this.shear(g, this.width, this.height, ObjectUtils.defaultIfNull(this.background, Color.WHITE));
        this.drawInterfere(g, 0, RandomUtils.randomInt(this.height) + 1, this.width, RandomUtils.randomInt(this.height) + 1, this.interfereCount, ImageUtils.randomColor());
        return image;
    }

    private void drawString(Graphics2D g, String code) {
        if (null != this.textAlpha) {
            g.setComposite(this.textAlpha);
        }
        Graphics.drawStringColourful(g, code, this.font, this.width, this.height);
    }

    private void shear(java.awt.Graphics g, int w1, int h1, Color color) {
        this.shearX(g, w1, h1, color);
        this.shearY(g, w1, h1, color);
    }

    private void shearX(java.awt.Graphics g, int w1, int h1, Color color) {
        int period = RandomUtils.randomInt(this.width);
        boolean frames = true;
        int phase = RandomUtils.randomInt(2);
        for (int i = 0; i < h1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(0, i, w1, 1, (int)d, 0);
            g.setColor(color);
            g.drawLine((int)d, i, 0, i);
            g.drawLine((int)d + w1, i, w1, i);
        }
    }

    private void shearY(java.awt.Graphics g, int w1, int h1, Color color) {
        int period = RandomUtils.randomInt(this.height >> 1);
        int frames = 20;
        int phase = 7;
        for (int i = 0; i < w1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(i, 0, 1, h1, 0, (int)d);
            g.setColor(color);
            g.drawLine(i, (int)d, i, 0);
            g.drawLine(i, (int)d + h1, i, h1);
        }
    }

    private void drawInterfere(java.awt.Graphics g, int x1, int y1, int x2, int y2, int thickness, Color c) {
        g.setColor(c);
        int dX = x2 - x1;
        int dY = y2 - y1;
        double lineLength = Math.sqrt(dX * dX + dY * dY);
        double scale = (double)thickness / (2.0 * lineLength);
        double ddx = -scale * (double)dY;
        double ddy = scale * (double)dX;
        double d = ddy > 0.0 ? 0.5 : -0.5;
        int dx = (int)(ddx += ddx > 0.0 ? 0.5 : -0.5);
        int dy = (int)(ddy += d);
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        xPoints[0] = x1 + dx;
        yPoints[0] = y1 + dy;
        xPoints[1] = x1 - dx;
        yPoints[1] = y1 - dy;
        xPoints[2] = x2 - dx;
        yPoints[2] = y2 - dy;
        xPoints[3] = x2 + dx;
        yPoints[3] = y2 + dy;
        g.fillPolygon(xPoints, yPoints, 4);
    }
}

