/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.ftp;

import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.extra.ftp.FtpConfig;

public abstract class AbstractFtp
implements Closeable {
    public static final Charset DEFAULT_CHARSET = org.aoju.bus.core.lang.Charset.UTF_8;
    protected FtpConfig ftpConfig;

    protected AbstractFtp(FtpConfig config) {
        this.ftpConfig = config;
    }

    private static boolean containsIgnoreCase(List<String> names, String nameToFind) {
        if (CollUtils.isEmpty(names)) {
            return false;
        }
        if (StringUtils.isEmpty(nameToFind)) {
            return false;
        }
        for (String name : names) {
            if (!nameToFind.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public abstract AbstractFtp reconnectIfTimeout();

    public abstract boolean cd(String var1);

    public boolean toParent() {
        return this.cd("..");
    }

    public abstract String pwd();

    public abstract boolean mkdir(String var1);

    public boolean exist(String path) {
        String fileName = FileUtils.getName(path);
        String dir = StringUtils.removeSuffix(path, fileName);
        List<String> names = this.ls(dir);
        return AbstractFtp.containsIgnoreCase(names, fileName);
    }

    public abstract List<String> ls(String var1);

    public abstract boolean delFile(String var1);

    public abstract boolean delDir(String var1);

    public void mkDirs(String dir) {
        String[] dirs = StringUtils.trim(dir).split("[\\\\/]+");
        String now = this.pwd();
        if (dirs.length > 0 && StringUtils.isEmpty(dirs[0])) {
            this.cd("/");
        }
        for (String s : dirs) {
            if (!StringUtils.isNotEmpty(s) || this.cd(s)) continue;
            this.mkdir(s);
            this.cd(s);
        }
        this.cd(now);
    }

    public abstract boolean upload(String var1, File var2);

    public abstract void download(String var1, File var2);

    public abstract void download(String var1, String var2);
}

