/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.JSONLibDataFormatSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;

public class JsonUtils {
    private static final SerializeConfig config;
    private static final SerializerFeature[] features;

    public static String convertObjectToJSON(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])features);
    }

    public static String toJSONNoFeatures(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static Object toBean(String text) {
        return JSON.parse((String)text);
    }

    public static Object[] toArray(String text) {
        return JsonUtils.toArray(text, null);
    }

    public static <T> T toBean(String text, Class<T> clazz) {
        return (T)JSON.parseObject((String)text, clazz);
    }

    public static <T> Object[] toArray(String text, Class<T> clazz) {
        return JSON.parseArray((String)text, clazz).toArray();
    }

    public static <T> List<T> toList(String text, Class<T> clazz) {
        return JSON.parseArray((String)text, clazz);
    }

    public static Object textToJson(String text) {
        return JSON.parse((String)text);
    }

    public static <K, V> Map<K, V> stringToCollect(String text) {
        return JSONObject.parseObject((String)text);
    }

    public static Object convertJsonToObject(String text, Class<?> clazz) {
        return JSONObject.parseObject((String)text, clazz);
    }

    public static <K, V> String collectToString(Map<K, V> map) {
        return JSONObject.toJSONString(map);
    }

    public static <T> List<T> convertJsonToList(String text, Class<T> clazz) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (!text.equals("")) {
            if (!text.contains("{") && !text.contains("[")) {
                try {
                    text = URLDecoder.decode(text, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new InstrumentException(e);
                }
            }
            JSON alljson = (JSON)JSON.parse((String)text);
            List alljsonlist = (List)JSON.toJavaObject((JSON)alljson, List.class);
            for (int i = 0; i < alljsonlist.size(); ++i) {
                JSON json = (JSON)alljsonlist.get(i);
                try {
                    list.add(JSON.toJavaObject((JSON)json, clazz.newInstance().getClass()));
                    continue;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new InstrumentException(e);
                }
            }
        }
        return list;
    }

    public static String toJson(Object object) {
        try {
            return JSON.toJSON((Object)object).toString();
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static JSON toJsonBean(Object object) {
        try {
            if (object == null) {
                return null;
            }
            return (JSON)JSON.toJSON((Object)object);
        }
        catch (ClassCastException e) {
            return JSON.parseObject((String)("" + object.toString()));
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static final boolean isJson(String content) {
        try {
            if (StringUtils.isBlank(content)) {
                return false;
            }
            JSON.parse((String)content);
        }
        catch (JSONException ex) {
            return false;
        }
        return true;
    }

    public static boolean isJsonObject(String content) {
        try {
            if (StringUtils.isBlank(content)) {
                return false;
            }
            JSONObject.parseObject((String)content);
        }
        catch (JSONException e) {
            return false;
        }
        return true;
    }

    public static boolean isJsonArray(String content) {
        try {
            if (StringUtils.isBlank(content)) {
                return false;
            }
            JSONArray.parseArray((String)content);
        }
        catch (JSONException e) {
            return false;
        }
        return true;
    }

    static {
        features = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullStringAsEmpty};
        config = new SerializeConfig();
        config.put(java.util.Date.class, (ObjectSerializer)new JSONLibDataFormatSerializer());
        config.put(Date.class, (ObjectSerializer)new JSONLibDataFormatSerializer());
    }
}

