/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Config;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.hardware.AbstractCentralProcessor;
import org.aoju.bus.health.builtin.hardware.CentralProcessor;
import org.aoju.bus.health.linux.LinuxLibc;
import org.aoju.bus.health.linux.ProcPath;
import org.aoju.bus.health.linux.drivers.CpuStat;
import org.aoju.bus.health.linux.software.LinuxOperatingSystem;

@ThreadSafe
final class LinuxCentralProcessor
extends AbstractCentralProcessor {
    private static final String CPUFREQ_PATH = "health.cpu.path";

    LinuxCentralProcessor() {
    }

    private static Map<Integer, Integer> mapNumaNodes() {
        HashMap<Integer, Integer> numaNodeMap = new HashMap<Integer, Integer>();
        List<String> lscpu = Executor.runNative("lscpu -p=cpu,node");
        for (String line : lscpu) {
            String[] split;
            if (line.startsWith("#") || (split = line.split(",")).length != 2) continue;
            numaNodeMap.put(Builder.parseIntOrDefault(split[0], 0), Builder.parseIntOrDefault(split[1], 0));
        }
        return numaNodeMap;
    }

    private static String getProcessorID(String vendor, String stepping, String model, String family, String[] flags) {
        boolean procInfo = false;
        String marker = "Processor Information";
        for (String checkLine : Executor.runNative("dmidecode -t 4")) {
            if (!procInfo && checkLine.contains(marker)) {
                marker = "ID:";
                procInfo = true;
                continue;
            }
            if (!procInfo || !checkLine.contains(marker)) continue;
            return checkLine.split(marker)[1].trim();
        }
        marker = "eax=";
        for (String checkLine : Executor.runNative("cpuid -1r")) {
            if (!checkLine.contains(marker) || !checkLine.trim().startsWith("0x00000001")) continue;
            String eax = "";
            String edx = "";
            for (String register : Builder.whitespaces.split(checkLine)) {
                if (register.startsWith("eax=")) {
                    eax = Builder.removeMatchingString(register, "eax=0x");
                    continue;
                }
                if (!register.startsWith("edx=")) continue;
                edx = Builder.removeMatchingString(register, "edx=0x");
            }
            return edx + eax;
        }
        if (vendor.startsWith("0x")) {
            return LinuxCentralProcessor.createMIDR(vendor, stepping, model, family) + "00000000";
        }
        return LinuxCentralProcessor.createProcessorID(stepping, model, family, flags);
    }

    private static String createMIDR(String vendor, String stepping, String model, String family) {
        int midrBytes = 0;
        if (stepping.startsWith("r") && stepping.contains("p")) {
            String[] rev = stepping.substring(1).split("p");
            midrBytes |= Builder.parseLastInt(rev[1], 0);
            midrBytes |= Builder.parseLastInt(rev[0], 0) << 20;
        }
        midrBytes |= Builder.parseLastInt(model, 0) << 4;
        midrBytes |= Builder.parseLastInt(family, 0) << 16;
        return String.format("%08X", midrBytes |= Builder.parseLastInt(vendor, 0) << 24);
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        String cpuVendor = "";
        String cpuName = "";
        String cpuFamily = "";
        String cpuModel = "";
        String cpuStepping = "";
        boolean cpu64bit = false;
        StringBuilder armStepping = new StringBuilder();
        String[] flags = new String[]{};
        List<String> cpuInfo = Builder.readFile(ProcPath.CPUINFO);
        block23: for (String line : cpuInfo) {
            String[] splitLine = Builder.whitespacesColonWhitespace.split(line);
            if (splitLine.length < 2) continue;
            block13 : switch (splitLine[0]) {
                case "vendor_id": 
                case "CPU implementer": {
                    cpuVendor = splitLine[1];
                    break;
                }
                case "model name": {
                    cpuName = splitLine[1];
                    break;
                }
                case "flags": {
                    for (String flag : flags = splitLine[1].toLowerCase().split(" ")) {
                        if (!"lm".equals(flag)) continue;
                        cpu64bit = true;
                        break block13;
                    }
                    continue block23;
                }
                case "stepping": {
                    cpuStepping = splitLine[1];
                    break;
                }
                case "CPU variant": {
                    armStepping.insert(0, "r" + splitLine[1]);
                    break;
                }
                case "CPU revision": {
                    armStepping.append('p').append(splitLine[1]);
                    break;
                }
                case "model": 
                case "CPU part": {
                    cpuModel = splitLine[1];
                    break;
                }
                case "cpu family": 
                case "CPU architecture": {
                    cpuFamily = splitLine[1];
                    break;
                }
            }
        }
        if (cpuStepping.isEmpty()) {
            cpuStepping = armStepping.toString();
        }
        String processorID = LinuxCentralProcessor.getProcessorID(cpuVendor, cpuStepping, cpuModel, cpuFamily, flags);
        if (cpuVendor.startsWith("0x")) {
            List<String> lscpu = Executor.runNative("lscpu");
            for (String line : lscpu) {
                if (!line.startsWith("Architecture:")) continue;
                cpuVendor = line.replace("Architecture:", "").trim();
            }
        }
        return new CentralProcessor.ProcessorIdentifier(cpuVendor, cpuName, cpuFamily, cpuModel, cpuStepping, processorID, cpu64bit);
    }

    @Override
    protected CentralProcessor.LogicalProcessor[] initProcessorCounts() {
        Map<Integer, Integer> numaNodeMap = LinuxCentralProcessor.mapNumaNodes();
        List<String> procCpu = Builder.readFile(ProcPath.CPUINFO);
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>();
        int currentProcessor = 0;
        int currentCore = 0;
        int currentPackage = 0;
        boolean first = true;
        for (String cpu : procCpu) {
            if (cpu.startsWith("processor")) {
                if (!first) {
                    logProcs.add(new CentralProcessor.LogicalProcessor(currentProcessor, currentCore, currentPackage, numaNodeMap.getOrDefault(currentProcessor, 0)));
                } else {
                    first = false;
                }
                currentProcessor = Builder.parseLastInt(cpu, 0);
                continue;
            }
            if (cpu.startsWith("core id") || cpu.startsWith("cpu number")) {
                currentCore = Builder.parseLastInt(cpu, 0);
                continue;
            }
            if (!cpu.startsWith("physical id")) continue;
            currentPackage = Builder.parseLastInt(cpu, 0);
        }
        logProcs.add(new CentralProcessor.LogicalProcessor(currentProcessor, currentCore, currentPackage, numaNodeMap.getOrDefault(currentProcessor, 0)));
        return logProcs.toArray(new CentralProcessor.LogicalProcessor[0]);
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        long[] ticks = CpuStat.getSystemCpuLoadTicks();
        long hz = LinuxOperatingSystem.getHz();
        for (int i = 0; i < ticks.length; ++i) {
            ticks[i] = ticks[i] * 1000L / hz;
        }
        return ticks;
    }

    @Override
    public long[] queryCurrentFreq() {
        int i;
        String cpuFreqPath = Config.get(CPUFREQ_PATH, "");
        long[] freqs = new long[this.getLogicalProcessorCount()];
        long max = 0L;
        for (i = 0; i < freqs.length; ++i) {
            freqs[i] = Builder.getLongFromFile(cpuFreqPath + i + "/cpufreq/scaling_cur_freq");
            if (freqs[i] == 0L) {
                freqs[i] = Builder.getLongFromFile(cpuFreqPath + i + "/cpufreq/cpuinfo_cur_freq");
            }
            if (max >= freqs[i]) continue;
            max = freqs[i];
        }
        if (max > 0L) {
            i = 0;
            while (i < freqs.length) {
                int n = i++;
                freqs[n] = freqs[n] * 1000L;
            }
            return freqs;
        }
        Arrays.fill(freqs, -1L);
        List<String> cpuInfo = Builder.readFile(ProcPath.CPUINFO);
        int proc = 0;
        for (String s : cpuInfo) {
            if (!s.toLowerCase().contains("cpu mhz")) continue;
            freqs[proc] = (long)(Builder.parseLastDouble(s, 0.0) * 1000000.0);
            if (++proc < freqs.length) continue;
            break;
        }
        return freqs;
    }

    @Override
    public long queryMaxFreq() {
        String cpuFreqPath = Config.get(CPUFREQ_PATH, "");
        long max = 0L;
        for (int i = 0; i < this.getLogicalProcessorCount(); ++i) {
            long freq = Builder.getLongFromFile(cpuFreqPath + i + "/cpufreq/scaling_max_freq");
            if (freq == 0L) {
                freq = Builder.getLongFromFile(cpuFreqPath + i + "/cpufreq/cpuinfo_max_freq");
            }
            if (max >= freq) continue;
            max = freq;
        }
        if (max > 0L) {
            return max * 1000L;
        }
        return -1L;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = LinuxLibc.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i = Math.max(retval, 0); i < average.length; ++i) {
                average[i] = -1.0;
            }
        }
        return average;
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        long[][] ticks = CpuStat.getProcessorCpuLoadTicks(this.getLogicalProcessorCount());
        long hz = LinuxOperatingSystem.getHz();
        for (int i = 0; i < ticks.length; ++i) {
            for (int j = 0; j < ticks[i].length; ++j) {
                ticks[i][j] = ticks[i][j] * 1000L / hz;
            }
        }
        return ticks;
    }

    @Override
    public long queryContextSwitches() {
        return CpuStat.getContextSwitches();
    }

    @Override
    public long queryInterrupts() {
        return CpuStat.getInterrupts();
    }
}

