/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.hardware;

import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractFirmware;

@Immutable
final class FreeBsdFirmware
extends AbstractFirmware {
    private final Supplier<Triple<String, String, String>> manufVersRelease = Memoize.memoize(FreeBsdFirmware::readDmiDecode);

    FreeBsdFirmware() {
    }

    private static Triple<String, String, String> readDmiDecode() {
        String manufacturer = null;
        String version = null;
        String releaseDate = "";
        String manufacturerMarker = "Vendor:";
        String versionMarker = "Version:";
        String releaseDateMarker = "Release Date:";
        for (String checkLine : Executor.runNative("dmidecode -t bios")) {
            if (checkLine.contains("Vendor:")) {
                manufacturer = checkLine.split("Vendor:")[1].trim();
                continue;
            }
            if (checkLine.contains("Version:")) {
                version = checkLine.split("Version:")[1].trim();
                continue;
            }
            if (!checkLine.contains("Release Date:")) continue;
            releaseDate = checkLine.split("Release Date:")[1].trim();
        }
        releaseDate = Builder.parseMmDdYyyyToYyyyMmDD(releaseDate);
        return Triple.of(StringUtils.isBlank(manufacturer) ? "unknown" : manufacturer, StringUtils.isBlank(version) ? "unknown" : version, StringUtils.isBlank(releaseDate) ? "unknown" : releaseDate);
    }

    @Override
    public String getManufacturer() {
        return this.manufVersRelease.get().getLeft();
    }

    @Override
    public String getVersion() {
        return this.manufVersRelease.get().getMiddle();
    }

    @Override
    public String getReleaseDate() {
        return this.manufVersRelease.get().getRight();
    }
}

