/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.drivers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.health.builtin.software.OSProcess;
import org.aoju.bus.health.builtin.software.OperatingSystem;
import org.aoju.bus.health.windows.drivers.HkeyPerformanceDataUtil;
import org.aoju.bus.health.windows.drivers.ProcessInformation;

@ThreadSafe
public final class ProcessPerformanceData {
    private static final String PROCESS = "Process";

    private ProcessPerformanceData() {
    }

    public static Map<Integer, OSProcess> buildProcessMapFromRegistry(OperatingSystem os, Collection<Integer> pids) {
        Triple<List<Map<ProcessInformation.ProcessPerformanceProperty, Object>>, Long, Long> processData = HkeyPerformanceDataUtil.readPerfDataFromRegistry(PROCESS, ProcessInformation.ProcessPerformanceProperty.class);
        if (processData == null) {
            return null;
        }
        List<Map<ProcessInformation.ProcessPerformanceProperty, Object>> processInstanceMaps = processData.getLeft();
        long perfTime100nSec = processData.getMiddle();
        long now = processData.getRight();
        HashMap<Integer, OSProcess> processMap = new HashMap<Integer, OSProcess>();
        for (Map<ProcessInformation.ProcessPerformanceProperty, Object> processInstanceMap : processInstanceMaps) {
            int pid = (Integer)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.PROCESSID);
            String name = (String)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.NAME);
            if (pids != null && !pids.contains(pid) || "_Total".equals(name)) continue;
            OSProcess proc = new OSProcess(os);
            proc.setProcessID(pid);
            proc.setName(name);
            long upTime = (perfTime100nSec - (Long)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.CREATIONDATE)) / 10000L;
            proc.setUpTime(upTime < 1L ? 1L : upTime);
            proc.setStartTime(now - upTime);
            proc.setBytesRead((Long)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.READTRANSFERCOUNT));
            proc.setBytesWritten((Long)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.WRITETRANSFERCOUNT));
            proc.setResidentSetSize((Long)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.PRIVATEPAGECOUNT));
            proc.setParentProcessID((Integer)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.PARENTPROCESSID));
            proc.setPriority((Integer)processInstanceMap.get(ProcessInformation.ProcessPerformanceProperty.PRIORITY));
            processMap.put(pid, proc);
        }
        return processMap;
    }
}

