/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.media;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.utils.StringUtils;

public class HeaderFieldValues {
    private int start = 0;
    private int end = 0;
    private int position = 0;
    private char[] chars = null;
    private List<Map<String, String>> values;

    public HeaderFieldValues(String respContentType) {
        this.values = this.parse(respContentType);
    }

    protected boolean hasCharacter() {
        return this.position < this.chars.length;
    }

    protected String parseValue() {
        char c;
        this.start = this.position;
        this.end = this.position;
        while (this.hasCharacter() && (c = this.chars[this.position]) != '=' && c != ';') {
            ++this.end;
            ++this.position;
        }
        return this.getValue(false);
    }

    protected String parseQuotedValue() {
        this.start = this.position;
        this.end = this.position;
        boolean quoted = false;
        boolean charEscaped = false;
        while (this.hasCharacter()) {
            char c = this.chars[this.position];
            if (!quoted && c == ';') break;
            if (!charEscaped && c == '\"') {
                quoted = !quoted;
            }
            charEscaped = !charEscaped && c == '\\';
            ++this.end;
            ++this.position;
        }
        return this.getValue(true);
    }

    private String getValue(boolean quoted) {
        while (this.start < this.end && Character.isWhitespace(this.chars[this.start])) {
            ++this.start;
        }
        while (this.end > this.start && Character.isWhitespace(this.chars[this.end - 1])) {
            --this.end;
        }
        if (quoted && this.end - this.start >= 2 && this.chars[this.start] == '\"' && this.chars[this.end - 1] == '\"') {
            ++this.start;
            --this.end;
        }
        String result = null;
        if (this.end > this.start) {
            result = new String(this.chars, this.start, this.end - this.start);
        }
        return result;
    }

    protected List<Map<String, String>> parse(String content) {
        ArrayList<Map<String, String>> hvals = new ArrayList<Map<String, String>>();
        if (StringUtils.hasText(content)) {
            String[] elements;
            for (String element : elements = content.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)")) {
                HashMap<String, String> params = new HashMap<String, String>();
                hvals.add(params);
                this.chars = element.toCharArray();
                this.position = 0;
                while (this.hasCharacter()) {
                    String name = this.parseValue();
                    String value = null;
                    if (this.hasCharacter() && this.chars[this.position] == '=') {
                        ++this.position;
                        value = this.parseQuotedValue();
                    }
                    if (this.hasCharacter() && this.chars[this.position] == ';') {
                        ++this.position;
                    }
                    if (!StringUtils.hasText(name)) continue;
                    params.put(name.toLowerCase(), value);
                }
            }
        }
        return hvals;
    }

    public List<Map<String, String>> getValues() {
        return this.values;
    }

    public void setValues(List<Map<String, String>> values) {
        this.values = values;
    }

    public boolean hasKey(String key) {
        for (Map<String, String> map : this.values) {
            if (!map.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public String getValue(String key) {
        for (Map<String, String> map : this.values) {
            String val = map.get(key);
            if (!StringUtils.hasText(val)) continue;
            return val;
        }
        return null;
    }

    public List<String> getValues(String key) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map<String, String> map : this.values) {
            String val = map.get(key);
            if (!StringUtils.hasText(val)) continue;
            list.add(val);
        }
        return list;
    }
}

