/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.text.MessageFormat;
import org.aoju.bus.image.Args;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.Node;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.ElementDictionary;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.service.Level;
import org.aoju.bus.image.plugin.FindSCU;
import org.aoju.bus.logger.Logger;

public class CFind {
    public static final Args PatientID = new Args(0x100020, new String[0]);
    public static final Args IssuerOfPatientID = new Args(0x100021, new String[0]);
    public static final Args PatientName = new Args(0x100010, new String[0]);
    public static final Args PatientBirthDate = new Args(0x100030, new String[0]);
    public static final Args PatientSex = new Args(0x100040, new String[0]);
    public static final Args StudyInstanceUID = new Args(0x20000D, new String[0]);
    public static final Args AccessionNumber = new Args(524368, new String[0]);
    public static final Args IssuerOfAccessionNumberSequence = new Args(524369, new String[0]);
    public static final Args StudyID = new Args(0x200010, new String[0]);
    public static final Args ReferringPhysicianName = new Args(524432, new String[0]);
    public static final Args StudyDescription = new Args(528432, new String[0]);
    public static final Args StudyDate = new Args(524320, new String[0]);
    public static final Args StudyTime = new Args(524336, new String[0]);
    public static final Args SeriesInstanceUID = new Args(0x20000E, new String[0]);
    public static final Args Modality = new Args(524384, new String[0]);
    public static final Args SeriesNumber = new Args(0x200011, new String[0]);
    public static final Args SeriesDescription = new Args(528446, new String[0]);
    public static final Args SOPInstanceUID = new Args(524312, new String[0]);
    public static final Args InstanceNumber = new Args(2097171, new String[0]);

    public static Status process(Node callingNode, Node calledNode, Args ... keys) {
        return CFind.process(new Args(), callingNode, calledNode, 0, Level.STUDY, keys);
    }

    public static Status process(Args args, Node callingNode, Node calledNode, Args ... keys) {
        return CFind.process(args, callingNode, calledNode, 0, Level.STUDY, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static Status process(Args args, Node callingNode, Node calledNode, int cancelAfter, Level level, Args ... keys) {
        if (callingNode == null || calledNode == null) {
            throw new IllegalArgumentException("callingNode or calledNode cannot be null!");
        }
        try {
            Throwable throwable = null;
            try (FindSCU findSCU = new FindSCU();){
                Status status;
                Connection remote = findSCU.getRemoteConnection();
                Connection conn = findSCU.getConnection();
                args.configureBind(findSCU.getAAssociateRQ(), remote, calledNode);
                args.configureBind(findSCU.getApplicationEntity(), conn, callingNode);
                Device device = findSCU.getDevice();
                args.configure(conn);
                args.configureTLS(conn, remote);
                findSCU.setInformationModel(CFind.getInformationModel(args), args.getTsuidOrder(), args.getTypes());
                if (level != null) {
                    findSCU.addLevel(level.name());
                }
                for (Args p : keys) {
                    CFind.addAttributes(findSCU.getKeys(), p);
                }
                findSCU.setCancelAfter(cancelAfter);
                findSCU.setPriority(args.getPriority());
                device.start();
                try {
                    Status dcmState = findSCU.getState();
                    long t1 = System.currentTimeMillis();
                    findSCU.open();
                    long t2 = System.currentTimeMillis();
                    findSCU.query();
                    Builder.forceGettingAttributes(dcmState, findSCU);
                    long t3 = System.currentTimeMillis();
                    String timeMsg = MessageFormat.format("DICOM C-Find connected in {2}ms from {0} to {1}. Query in {3}ms.", findSCU.getAAssociateRQ().getCallingAET(), findSCU.getAAssociateRQ().getCalledAET(), t2 - t1, t3 - t2);
                    status = Status.build(dcmState, timeMsg, null);
                }
                catch (Exception e) {
                    Status status2;
                    block25: {
                        block26: {
                            Logger.error("findscu", e);
                            Builder.forceGettingAttributes(findSCU.getState(), findSCU);
                            status2 = Status.build(findSCU.getState(), null, e);
                            Builder.close(findSCU);
                            device.stop();
                            if (findSCU == null) break block25;
                            if (throwable == null) break block26;
                            try {
                                findSCU.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block25;
                        }
                        findSCU.close();
                    }
                    return status2;
                    {
                        catch (Throwable throwable3) {
                            try {
                                Builder.close(findSCU);
                                device.stop();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                        }
                    }
                }
                Builder.close(findSCU);
                device.stop();
                return status;
            }
        }
        catch (Exception e) {
            Logger.error("findscu", e);
            return new Status(49152, "DICOM Find failed :" + e.getMessage(), null);
        }
    }

    private static FindSCU.InformationModel getInformationModel(Args options) {
        Object model = options.getInformationModel();
        if (model instanceof FindSCU.InformationModel) {
            return (FindSCU.InformationModel)((Object)model);
        }
        return FindSCU.InformationModel.StudyRoot;
    }

    public static void addAttributes(Attributes attrs, Args param) {
        int tag = param.getTag();
        String[] ss = param.getValues();
        VR vr = ElementDictionary.vrOf(tag, attrs.getPrivateCreator(tag));
        if (ss == null || ss.length == 0) {
            if (vr == VR.SQ) {
                attrs.newSequence(tag, 1).add(new Attributes(0));
            } else {
                attrs.setNull(tag, vr);
            }
        } else {
            attrs.setString(tag, vr, ss);
        }
    }
}

