/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BookUtils {
    public static Workbook createBook(String excelFilePath) {
        return BookUtils.createBook(FileUtils.file(excelFilePath), null);
    }

    public static Workbook createBook(File excelFile) {
        return BookUtils.createBook(excelFile, null);
    }

    public static Workbook createBookForWriter(File excelFile) {
        if (null == excelFile) {
            return BookUtils.createBook(true);
        }
        if (excelFile.exists()) {
            return BookUtils.createBook(FileUtils.getInputStream(excelFile), true);
        }
        return BookUtils.createBook(StringUtils.endWithIgnoreCase(excelFile.getName(), ".xlsx"));
    }

    public static Workbook createBook(File excelFile, String password) {
        try {
            return WorkbookFactory.create((File)excelFile, (String)password);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static Workbook createBook(InputStream in, boolean closeAfterRead) {
        return BookUtils.createBook(in, null, closeAfterRead);
    }

    public static Workbook createBook(InputStream in, String password, boolean closeAfterRead) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)IoUtils.toMarkSupportStream(in), (String)password);
            return workbook;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            if (closeAfterRead) {
                IoUtils.close(in);
            }
        }
    }

    public static Workbook createBook(boolean isXlsx) {
        Object workbook = isXlsx ? new XSSFWorkbook() : new HSSFWorkbook();
        return workbook;
    }

    public static SXSSFWorkbook createSXSSFBook(String excelFilePath) {
        return BookUtils.createSXSSFBook(FileUtils.file(excelFilePath), null);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile) {
        return BookUtils.createSXSSFBook(excelFile, null);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile, String password) {
        return BookUtils.toSXSSFBook(BookUtils.createBook(excelFile, password));
    }

    public static SXSSFWorkbook createSXSSFBook(InputStream in, boolean closeAfterRead) {
        return BookUtils.createSXSSFBook(in, null, closeAfterRead);
    }

    public static SXSSFWorkbook createSXSSFBook(InputStream in, String password, boolean closeAfterRead) {
        return BookUtils.toSXSSFBook(BookUtils.createBook(in, password, closeAfterRead));
    }

    public static SXSSFWorkbook createSXSSFBook() {
        return new SXSSFWorkbook();
    }

    public static SXSSFWorkbook createSXSSFBook(int rowAccessWindowSize) {
        return new SXSSFWorkbook(rowAccessWindowSize);
    }

    public static void writeBook(Workbook book, OutputStream out) throws InstrumentException {
        try {
            book.write(out);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static Sheet getOrCreateSheet(Workbook book, String sheetName) {
        if (null == book) {
            return null;
        }
        Sheet sheet = book.getSheet(sheetName = StringUtils.isBlank(sheetName) ? "sheet1" : sheetName);
        if (null == sheet) {
            sheet = book.createSheet(sheetName);
        }
        return sheet;
    }

    public static Sheet getOrCreateSheet(Workbook book, int sheetIndex) {
        Sheet sheet = null;
        try {
            sheet = book.getSheetAt(sheetIndex);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (null == sheet) {
            sheet = book.createSheet();
        }
        return sheet;
    }

    public static boolean isEmpty(Sheet sheet) {
        return null == sheet || sheet.getLastRowNum() == 0 && sheet.getPhysicalNumberOfRows() == 0;
    }

    private static SXSSFWorkbook toSXSSFBook(Workbook book) {
        if (book instanceof SXSSFWorkbook) {
            return (SXSSFWorkbook)book;
        }
        if (book instanceof XSSFWorkbook) {
            return new SXSSFWorkbook((XSSFWorkbook)book);
        }
        throw new InstrumentException("The input is not a [xlsx] format.");
    }
}

