/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.TextKit;

public class BeanPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char[] expChars = new char[]{'.', '[', ']'};
    protected List<String> patternParts;
    private boolean isStartWith$ = false;

    public BeanPath(String expression) {
        this.init(expression);
    }

    public static BeanPath create(String expression) {
        return new BeanPath(expression);
    }

    private static Object getFieldValue(Object bean, String expression) {
        if (StringKit.isBlank(expression)) {
            return null;
        }
        if (StringKit.contains((CharSequence)expression, ':')) {
            List<String> parts = StringKit.splitTrim((CharSequence)expression, ':');
            int start = Integer.parseInt(parts.get(0));
            int end = Integer.parseInt(parts.get(1));
            int step = 1;
            if (3 == parts.size()) {
                step = Integer.parseInt(parts.get(2));
            }
            if (bean instanceof Collection) {
                return CollKit.sub((Collection)bean, start, end, step);
            }
            if (ArrayKit.isArray(bean)) {
                return ArrayKit.sub(bean, start, end, step);
            }
        } else if (StringKit.contains((CharSequence)expression, ',')) {
            List<String> keys = StringKit.splitTrim((CharSequence)expression, ',');
            if (bean instanceof Collection) {
                return CollKit.getAny((Collection)bean, Convert.convert(int[].class, keys));
            }
            if (ArrayKit.isArray(bean)) {
                return ArrayKit.get(bean, Convert.convert(int[].class, keys));
            }
            String[] unwrapedKeys = new String[keys.size()];
            for (int i = 0; i < unwrapedKeys.length; ++i) {
                unwrapedKeys[i] = StringKit.unWrap(keys.get(i), '\'');
            }
            if (bean instanceof Map) {
                MapKit.getAny((Map)bean, unwrapedKeys);
            } else {
                Map<String, Object> map = BeanKit.beanToMap(bean);
                MapKit.getAny(map, unwrapedKeys);
            }
        } else {
            return BeanKit.getFieldValue(bean, expression);
        }
        return null;
    }

    private static String unWrapIfPossible(CharSequence expression) {
        if (StringKit.containsAny(expression, " = ", " > ", " < ", " like ", ",")) {
            return expression.toString();
        }
        return StringKit.unWrap(expression, '\'');
    }

    public Object get(Object bean) {
        return this.get(this.patternParts, bean, false);
    }

    public void set(Object bean, Object value) {
        this.set(bean, this.patternParts, value);
    }

    private void set(Object bean, List<String> patternParts, Object value) {
        Object subBean = this.get(patternParts, bean, true);
        if (null == subBean) {
            this.set(bean, patternParts.subList(0, patternParts.size() - 1), new HashMap());
            subBean = this.get(patternParts, bean, true);
        }
        BeanKit.setFieldValue(subBean, patternParts.get(patternParts.size() - 1), value);
    }

    private Object get(List<String> patternParts, Object bean, boolean ignoreLast) {
        int length = patternParts.size();
        if (ignoreLast) {
            --length;
        }
        Object subBean = bean;
        boolean isFirst = true;
        for (int i = 0; i < length; ++i) {
            String patternPart = patternParts.get(i);
            if (null != (subBean = BeanPath.getFieldValue(subBean, patternPart))) continue;
            if (isFirst && !this.isStartWith$ && BeanKit.isMatchName(bean, patternPart, true)) {
                subBean = bean;
                isFirst = false;
                continue;
            }
            return null;
        }
        return subBean;
    }

    private void init(String expression) {
        ArrayList<String> localPatternParts = new ArrayList<String>();
        int length = expression.length();
        TextKit builder = new TextKit();
        boolean isNumStart = false;
        for (int i = 0; i < length; ++i) {
            char c = expression.charAt(i);
            if (0 == i && '$' == c) {
                this.isStartWith$ = true;
                continue;
            }
            if (ArrayKit.contains(expChars, c)) {
                if (']' == c) {
                    if (!isNumStart) {
                        throw new IllegalArgumentException(StringKit.format("Bad expression '{}':{}, we find ']' but no '[' !", expression, i));
                    }
                    isNumStart = false;
                } else {
                    if (isNumStart) {
                        throw new IllegalArgumentException(StringKit.format("Bad expression '{}':{}, we find '[' but no ']' !", expression, i));
                    }
                    if ('[' == c) {
                        isNumStart = true;
                    }
                }
                if (builder.length() > 0) {
                    localPatternParts.add(BeanPath.unWrapIfPossible(builder));
                }
                builder.reset();
                continue;
            }
            builder.append(c);
        }
        if (isNumStart) {
            throw new IllegalArgumentException(StringKit.format("Bad expression '{}':{}, we find '[' but no ']' !", expression, length - 1));
        }
        if (builder.length() > 0) {
            localPatternParts.add(BeanPath.unWrapIfPossible(builder));
        }
        this.patternParts = Collections.unmodifiableList(localPatternParts);
    }
}

