/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.gitlab.GitLabApiException;
import org.aoju.bus.gitlab.JacksonJsonEnumHelper;

public final class AccessToken {
    protected static final String USER_AGENT = "GitLab Client";
    protected static final String COOKIES_HEADER = "Set-Cookie";
    protected static final String NEW_USER_AUTHENTICITY_TOKEN_REGEX = "\"new_user\".*name=\\\"authenticity_token\\\"\\svalue=\\\"([^\\\"]*)\\\".*new_new_user";
    protected static final Pattern NEW_USER_AUTHENTICITY_TOKEN_PATTERN = Pattern.compile("\"new_user\".*name=\\\"authenticity_token\\\"\\svalue=\\\"([^\\\"]*)\\\".*new_new_user");
    protected static final String AUTHENTICITY_TOKEN_REGEX = "name=\\\"authenticity_token\\\"\\svalue=\\\"([^\\\"]*)\\\"";
    protected static final Pattern AUTHENTICITY_TOKEN_PATTERN = Pattern.compile("name=\\\"authenticity_token\\\"\\svalue=\\\"([^\\\"]*)\\\"");
    protected static final String PERSONAL_ACCESS_TOKEN_REGEX = "name=\\\"created-personal-access-token\\\".*data-clipboard-text=\\\"([^\\\"]*)\\\".*\\/>";
    protected static final Pattern PERSONAL_ACCESS_TOKEN_PATTERN = Pattern.compile("name=\\\"created-personal-access-token\\\".*data-clipboard-text=\\\"([^\\\"]*)\\\".*\\/>");
    protected static final String REVOKE_PERSONAL_ACCESS_TOKEN_REGEX = "href=\\\"([^\\\"]*)\\\"";
    protected static final Pattern REVOKE_PERSONAL_ACCESS_TOKEN_PATTERN = Pattern.compile("href=\\\"([^\\\"]*)\\\"");
    protected static final String FEED_TOKEN_REGEX = "name=\\\"feed_token\\\".*value=\\\"([^\\\"]*)\\\".*\\/>";
    protected static final Pattern FEED_TOKEN_PATTERN = Pattern.compile("name=\\\"feed_token\\\".*value=\\\"([^\\\"]*)\\\".*\\/>");
    protected static final String HEALTH_CHECK_ACCESS_TOKEN_REGEX = "id=\"health-check-token\">([^<]*)<\\/code>";
    protected static final Pattern HEALTH_CHECK_ACCESS_TOKEN_PATTERN = Pattern.compile("id=\"health-check-token\">([^<]*)<\\/code>");

    public static final String createPersonalAccessToken(String baseUrl, String username, String password, String tokenName, Scope[] scopes) throws GitLabApiException {
        if (scopes == null || scopes.length == 0) {
            throw new RuntimeException("scopes cannot be null or empty");
        }
        return AccessToken.createPersonalAccessToken(baseUrl, username, password, tokenName, Arrays.asList(scopes));
    }

    public static final String createPersonalAccessToken(String baseUrl, String username, String password, String tokenName, List<Scope> scopes) throws GitLabApiException {
        boolean savedFollowRedirects = HttpURLConnection.getFollowRedirects();
        String cookies = null;
        try {
            String personalAccessToken;
            if (savedFollowRedirects) {
                HttpURLConnection.setFollowRedirects(false);
            }
            cookies = AccessToken.login(baseUrl, username, password);
            String urlString = baseUrl + "/profile/personal_access_tokens";
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setRequestProperty("Cookie", cookies);
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new GitLabApiException("Failure loading Access Tokens page, aborting!");
            }
            String content = AccessToken.getContent(connection);
            Matcher matcher = AUTHENTICITY_TOKEN_PATTERN.matcher(content);
            if (!matcher.find()) {
                throw new GitLabApiException("authenticity_token not found, aborting!");
            }
            String csrfToken = matcher.group(1);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Charset", "utf-8");
            connection.setRequestProperty("Cookie", cookies);
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            StringBuilder formData = new StringBuilder();
            AccessToken.addFormData(formData, "authenticity_token", csrfToken);
            AccessToken.addFormData(formData, "personal_access_token[name]", tokenName);
            AccessToken.addFormData(formData, "personal_access_token[expires_at]", "");
            if (scopes != null && scopes.size() > 0) {
                for (Scope scope : scopes) {
                    AccessToken.addFormData(formData, "personal_access_token[scopes][]", scope.toString());
                }
            }
            connection.setRequestProperty("Content-Length", String.valueOf(formData.length()));
            OutputStream output = connection.getOutputStream();
            output.write(formData.toString().getBytes());
            output.flush();
            output.close();
            responseCode = connection.getResponseCode();
            if (responseCode != 302) {
                throw new GitLabApiException("Failure creating personal access token, aborting!");
            }
            String redirectUrl = connection.getHeaderField("Location");
            url = new URL(redirectUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setRequestProperty("Cookie", cookies);
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new GitLabApiException("Failure creating personal access token, aborting!");
            }
            content = AccessToken.getContent(connection);
            matcher = PERSONAL_ACCESS_TOKEN_PATTERN.matcher(content);
            if (!matcher.find()) {
                throw new GitLabApiException("created-personal-access-token not found, aborting!");
            }
            String string = personalAccessToken = matcher.group(1);
            return string;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
        finally {
            if (cookies != null) {
                try {
                    AccessToken.logout(baseUrl, cookies);
                }
                catch (Exception exception) {}
            }
            if (savedFollowRedirects) {
                HttpURLConnection.setFollowRedirects(true);
            }
        }
    }

    public static final void revokePersonalAccessToken(String baseUrl, String username, String password, String tokenName, Scope[] scopes) throws GitLabApiException {
        if (scopes == null || scopes.length == 0) {
            throw new RuntimeException("scopes cannot be null or empty");
        }
        AccessToken.revokePersonalAccessToken(baseUrl, username, password, tokenName, Arrays.asList(scopes));
    }

    public static final void revokePersonalAccessToken(String baseUrl, String username, String password, String tokenName, List<Scope> scopes) throws GitLabApiException {
        boolean savedFollowRedirects = HttpURLConnection.getFollowRedirects();
        String cookies = null;
        try {
            if (savedFollowRedirects) {
                HttpURLConnection.setFollowRedirects(false);
            }
            cookies = AccessToken.login(baseUrl, username, password);
            String urlString = baseUrl + "/profile/personal_access_tokens";
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setRequestProperty("Cookie", cookies);
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new GitLabApiException("Failure loading Access Tokens page, aborting!");
            }
            String content = AccessToken.getContent(connection);
            Matcher matcher = AUTHENTICITY_TOKEN_PATTERN.matcher(content);
            if (!matcher.find()) {
                throw new GitLabApiException("authenticity_token not found, aborting!");
            }
            String csrfToken = matcher.group(1);
            int indexOfTokenName = content.indexOf("<td>" + tokenName + "</td>");
            if (indexOfTokenName == -1) {
                throw new GitLabApiException("personal access token not found, aborting!");
            }
            content = content.substring(indexOfTokenName);
            int indexOfLinkEnd = content.indexOf("</a>");
            if (indexOfTokenName == -1) {
                throw new GitLabApiException("personal access token not found, aborting!");
            }
            content = content.substring(0, indexOfLinkEnd);
            String scopesText = "";
            if (scopes != null && scopes.size() > 0) {
                StringJoiner joiner = new StringJoiner(", ");
                scopes.forEach(s -> joiner.add(s.toString()));
                scopesText = joiner.toString();
            }
            if (content.indexOf(scopesText) == -1) {
                throw new GitLabApiException("personal access token not found, aborting!");
            }
            matcher = REVOKE_PERSONAL_ACCESS_TOKEN_PATTERN.matcher(content);
            if (!matcher.find()) {
                throw new GitLabApiException("personal access token not found, aborting!");
            }
            String revokePath = matcher.group(1);
            url = new URL(baseUrl + revokePath);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Charset", "utf-8");
            connection.setRequestProperty("Cookie", cookies);
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            connection.setRequestMethod("PUT");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            StringBuilder formData = new StringBuilder();
            AccessToken.addFormData(formData, "authenticity_token", csrfToken);
            connection.setRequestProperty("Content-Length", String.valueOf(formData.length()));
            OutputStream output = connection.getOutputStream();
            output.write(formData.toString().getBytes());
            output.flush();
            output.close();
            responseCode = connection.getResponseCode();
            if (responseCode != 302) {
                throw new GitLabApiException("Failure revoking personal access token, aborting!");
            }
            String redirectUrl = connection.getHeaderField("Location");
            url = new URL(redirectUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setRequestProperty("Cookie", cookies);
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new GitLabApiException("Failure revoking personal access token, aborting!");
            }
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
        finally {
            if (cookies != null) {
                try {
                    AccessToken.logout(baseUrl, cookies);
                }
                catch (Exception exception) {}
            }
            if (savedFollowRedirects) {
                HttpURLConnection.setFollowRedirects(true);
            }
        }
    }

    public static final String getFeedToken(String baseUrl, String username, String password) throws GitLabApiException {
        boolean savedFollowRedirects = HttpURLConnection.getFollowRedirects();
        String cookies = null;
        try {
            String feedToken;
            if (savedFollowRedirects) {
                HttpURLConnection.setFollowRedirects(false);
            }
            cookies = AccessToken.login(baseUrl, username, password);
            String urlString = baseUrl + "/profile/personal_access_tokens";
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setRequestProperty("Cookie", cookies);
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new GitLabApiException("Failure loading Access Tokens page, aborting!");
            }
            String content = AccessToken.getContent(connection);
            Matcher matcher = FEED_TOKEN_PATTERN.matcher(content);
            if (!matcher.find()) {
                throw new GitLabApiException("Feed token not found, aborting!");
            }
            String string = feedToken = matcher.group(1);
            return string;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
        finally {
            if (cookies != null) {
                try {
                    AccessToken.logout(baseUrl, cookies);
                }
                catch (Exception exception) {}
            }
            if (savedFollowRedirects) {
                HttpURLConnection.setFollowRedirects(true);
            }
        }
    }

    public static final String getHealthCheckAccessToken(String baseUrl, String username, String password) throws GitLabApiException {
        boolean savedFollowRedirects = HttpURLConnection.getFollowRedirects();
        String cookies = null;
        try {
            String healthCheckAccessToken;
            if (savedFollowRedirects) {
                HttpURLConnection.setFollowRedirects(false);
            }
            cookies = AccessToken.login(baseUrl, username, password);
            String urlString = baseUrl + "/admin/health_check";
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setRequestProperty("Cookie", cookies);
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new GitLabApiException("Failure loading Health Check page, aborting!");
            }
            String content = AccessToken.getContent(connection);
            Matcher matcher = HEALTH_CHECK_ACCESS_TOKEN_PATTERN.matcher(content);
            if (!matcher.find()) {
                throw new GitLabApiException("health-check-access-token not found, aborting!");
            }
            String string = healthCheckAccessToken = matcher.group(1);
            return string;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
        finally {
            if (cookies != null) {
                try {
                    AccessToken.logout(baseUrl, cookies);
                }
                catch (Exception exception) {}
            }
            if (savedFollowRedirects) {
                HttpURLConnection.setFollowRedirects(true);
            }
        }
    }

    protected static final String login(String baseUrl, String username, String password) throws GitLabApiException {
        boolean savedFollowRedirects = HttpURLConnection.getFollowRedirects();
        try {
            if (savedFollowRedirects) {
                HttpURLConnection.setFollowRedirects(false);
            }
            String urlString = baseUrl + "/users/sign_in";
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.addRequestProperty("User-Agent", USER_AGENT);
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new GitLabApiException("Invalid state, aborting!");
            }
            String[] cookieParts = connection.getHeaderField(COOKIES_HEADER).split(";");
            String cookies = cookieParts[0];
            String content = AccessToken.getContent(connection);
            Matcher matcher = NEW_USER_AUTHENTICITY_TOKEN_PATTERN.matcher(content);
            if (!matcher.find()) {
                throw new GitLabApiException("authenticity_token not found, aborting!");
            }
            String csrfToken = matcher.group(1);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Charset", "utf-8");
            connection.setRequestProperty("Cookie", cookies);
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            StringBuilder formData = new StringBuilder();
            AccessToken.addFormData(formData, "user[login]", username);
            AccessToken.addFormData(formData, "user[password]", password);
            AccessToken.addFormData(formData, "authenticity_token", csrfToken);
            connection.setRequestProperty("Content-Length", String.valueOf(formData.length()));
            OutputStream output = connection.getOutputStream();
            output.write(formData.toString().getBytes());
            output.flush();
            output.close();
            responseCode = connection.getResponseCode();
            if (responseCode != 302) {
                throw new GitLabApiException("Login failure, aborting!", 401);
            }
            cookieParts = connection.getHeaderField(COOKIES_HEADER).split(";");
            cookies = cookieParts[0];
            String redirectUrl = connection.getHeaderField("Location");
            url = new URL(redirectUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setRequestProperty("Cookie", cookies);
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new GitLabApiException("Login failure, aborting!", 401);
            }
            String string = cookies;
            return string;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
        finally {
            if (savedFollowRedirects) {
                HttpURLConnection.setFollowRedirects(true);
            }
        }
    }

    protected static final void logout(String baseUrl, String cookies) throws GitLabApiException {
        boolean savedFollowRedirects = HttpURLConnection.getFollowRedirects();
        try {
            if (savedFollowRedirects) {
                HttpURLConnection.setFollowRedirects(false);
            }
            String urlString = baseUrl + "/users/sign_out";
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setRequestProperty("Cookie", cookies);
            connection.setRequestMethod("GET");
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 302) {
                throw new GitLabApiException("Logout failure, aborting!");
            }
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
        finally {
            if (savedFollowRedirects) {
                HttpURLConnection.setFollowRedirects(true);
            }
        }
    }

    public static final StringBuilder addFormData(StringBuilder formData, String name, String value) throws GitLabApiException {
        if (formData == null) {
            formData = new StringBuilder();
        } else if (formData.length() > 0) {
            formData.append("&");
        }
        formData.append(name);
        formData.append("=");
        try {
            formData.append(URLEncoder.encode(value, "UTF-8"));
            return formData;
        }
        catch (Exception e) {
            throw new GitLabApiException(e);
        }
    }

    protected static String getContent(URLConnection connection) throws GitLabApiException {
        StringBuilder buf = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            reader.lines().forEach(b -> buf.append((String)b));
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
        return buf.toString();
    }

    public static enum Scope {
        API,
        READ_REGISTRY,
        READ_REPOSITORY,
        READ_USER,
        SUDO,
        WRITE_REPOSITORY;

        private static JacksonJsonEnumHelper<Scope> enumHelper;

        @JsonCreator
        public static Scope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<Scope>(Scope.class);
        }
    }
}

