/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractGlobalMemory;
import org.aoju.bus.health.builtin.hardware.VirtualMemory;
import org.aoju.bus.health.linux.ProcPath;
import org.aoju.bus.health.linux.hardware.LinuxVirtualMemory;

@ThreadSafe
final class LinuxGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<Pair<Long, Long>> availTotal = Memoize.memoize(LinuxGlobalMemory::readMemInfo, Memoize.defaultExpiration());
    private final Supplier<Long> pageSize = Memoize.memoize(LinuxGlobalMemory::queryPageSize);
    private final Supplier<VirtualMemory> vm = Memoize.memoize(this::createVirtualMemory);

    LinuxGlobalMemory() {
    }

    private static long queryPageSize() {
        return Builder.parseLongOrDefault(Executor.getFirstAnswer("getconf PAGE_SIZE"), 4096L);
    }

    private static Pair<Long, Long> readMemInfo() {
        long memFree = 0L;
        long activeFile = 0L;
        long inactiveFile = 0L;
        long sReclaimable = 0L;
        long memTotal = 0L;
        List<String> procMemInfo = Builder.readFile(ProcPath.MEMINFO);
        for (String checkLine : procMemInfo) {
            String[] memorySplit = Builder.whitespaces.split(checkLine);
            if (memorySplit.length <= 1) continue;
            switch (memorySplit[0]) {
                case "MemTotal:": {
                    memTotal = LinuxGlobalMemory.parseMeminfo(memorySplit);
                    break;
                }
                case "MemAvailable:": {
                    long memAvailable = LinuxGlobalMemory.parseMeminfo(memorySplit);
                    return Pair.of(memAvailable, memTotal);
                }
                case "MemFree:": {
                    memFree = LinuxGlobalMemory.parseMeminfo(memorySplit);
                    break;
                }
                case "Active(file):": {
                    activeFile = LinuxGlobalMemory.parseMeminfo(memorySplit);
                    break;
                }
                case "Inactive(file):": {
                    inactiveFile = LinuxGlobalMemory.parseMeminfo(memorySplit);
                    break;
                }
                case "SReclaimable:": {
                    sReclaimable = LinuxGlobalMemory.parseMeminfo(memorySplit);
                    break;
                }
            }
        }
        return Pair.of(memFree + activeFile + inactiveFile + sReclaimable, memTotal);
    }

    private static long parseMeminfo(String[] memorySplit) {
        if (memorySplit.length < 2) {
            return 0L;
        }
        long memory = Builder.parseLongOrDefault(memorySplit[1], 0L);
        if (memorySplit.length > 2 && "kB".equals(memorySplit[2])) {
            memory *= 1024L;
        }
        return memory;
    }

    @Override
    public long getAvailable() {
        return this.availTotal.get().getLeft();
    }

    @Override
    public long getTotal() {
        return this.availTotal.get().getRight();
    }

    @Override
    public long getPageSize() {
        return this.pageSize.get();
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private VirtualMemory createVirtualMemory() {
        return new LinuxVirtualMemory(this);
    }
}

