/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.hardware.AbstractGraphicsCard;

@Immutable
final class LinuxGraphicsCard
extends AbstractGraphicsCard {
    LinuxGraphicsCard(String name, String deviceId, String vendor, String versionInfo, long vram) {
        super(name, deviceId, vendor, versionInfo, vram);
    }

    public static List<LinuxGraphicsCard> getGraphicsCards() {
        List<LinuxGraphicsCard> cardList = LinuxGraphicsCard.getGraphicsCardsFromLspci();
        if (cardList.isEmpty()) {
            cardList = LinuxGraphicsCard.getGraphicsCardsFromLshw();
        }
        return cardList;
    }

    private static List<LinuxGraphicsCard> getGraphicsCardsFromLspci() {
        ArrayList<LinuxGraphicsCard> cardList = new ArrayList<LinuxGraphicsCard>();
        List<String> lspci = Executor.runNative("lspci -vnnm");
        String name = "unknown";
        String deviceId = "unknown";
        String vendor = "unknown";
        ArrayList<String> versionInfoList = new ArrayList<String>();
        boolean found = false;
        String lookupDevice = null;
        for (String line : lspci) {
            Pair<String, String> pair;
            String[] split = line.trim().split(":", 2);
            String prefix = split[0];
            if (prefix.equals("Class") && line.contains("VGA")) {
                found = true;
            } else if (prefix.equals("Device") && !found && split.length > 1) {
                lookupDevice = split[1].trim();
            }
            if (!found) continue;
            if (split.length < 2) {
                cardList.add(new LinuxGraphicsCard(name, deviceId, vendor, versionInfoList.isEmpty() ? "unknown" : String.join((CharSequence)", ", versionInfoList), LinuxGraphicsCard.queryLspciMemorySize(lookupDevice)));
                versionInfoList.clear();
                found = false;
                continue;
            }
            if (prefix.equals("Device")) {
                pair = Builder.parseLspciMachineReadable(split[1].trim());
                if (pair == null) continue;
                name = pair.getLeft();
                deviceId = "0x" + pair.getRight();
                continue;
            }
            if (prefix.equals("Vendor")) {
                pair = Builder.parseLspciMachineReadable(split[1].trim());
                if (pair != null) {
                    vendor = pair.getLeft() + " (0x" + pair.getRight() + ")";
                    continue;
                }
                vendor = split[1].trim();
                continue;
            }
            if (!prefix.equals("Rev:")) continue;
            versionInfoList.add(line.trim());
        }
        if (found) {
            cardList.add(new LinuxGraphicsCard(name, deviceId, vendor, versionInfoList.isEmpty() ? "unknown" : String.join((CharSequence)", ", versionInfoList), LinuxGraphicsCard.queryLspciMemorySize(lookupDevice)));
        }
        return cardList;
    }

    private static long queryLspciMemorySize(String lookupDevice) {
        long vram = 0L;
        List<String> lspciMem = Executor.runNative("lspci -v -s " + lookupDevice);
        for (String mem : lspciMem) {
            if (!mem.contains(" prefetchable")) continue;
            vram += Builder.parseLspciMemorySize(mem);
        }
        return vram;
    }

    private static List<LinuxGraphicsCard> getGraphicsCardsFromLshw() {
        ArrayList<LinuxGraphicsCard> cardList = new ArrayList<LinuxGraphicsCard>();
        List<String> lshw = Executor.runNative("lshw -C display");
        String name = "unknown";
        String deviceId = "unknown";
        String vendor = "unknown";
        ArrayList<String> versionInfoList = new ArrayList<String>();
        long vram = 0L;
        int cardNum = 0;
        for (String line : lshw) {
            String[] split = line.trim().split(":");
            if (split[0].startsWith("*-display")) {
                if (cardNum++ <= 0) continue;
                cardList.add(new LinuxGraphicsCard(name, deviceId, vendor, versionInfoList.isEmpty() ? "unknown" : String.join((CharSequence)", ", versionInfoList), vram));
                versionInfoList.clear();
                continue;
            }
            if (split.length != 2) continue;
            String prefix = split[0];
            if (prefix.equals("product")) {
                name = split[1].trim();
                continue;
            }
            if (prefix.equals("vendor")) {
                vendor = split[1].trim();
                continue;
            }
            if (prefix.equals("version")) {
                versionInfoList.add(line.trim());
                continue;
            }
            if (!prefix.startsWith("resources")) continue;
            vram = Builder.parseLshwResourceString(split[1].trim());
        }
        cardList.add(new LinuxGraphicsCard(name, deviceId, vendor, versionInfoList.isEmpty() ? "unknown" : String.join((CharSequence)", ", versionInfoList), vram));
        return cardList;
    }
}

