/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.software;

import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.InternetProtocolStats;

@ThreadSafe
public class LinuxInternetProtocolStats
implements InternetProtocolStats {
    private static InternetProtocolStats.TcpStats getTcpStats(String netstatStr) {
        long connectionsEstablished = 0L;
        long connectionsActive = 0L;
        long connectionsPassive = 0L;
        long connectionFailures = 0L;
        long connectionsReset = 0L;
        long segmentsSent = 0L;
        long segmentsReceived = 0L;
        long segmentsRetransmitted = 0L;
        long inErrors = 0L;
        long outResets = 0L;
        List<String> netstat = Executor.runNative(netstatStr);
        for (String s : netstat) {
            String[] split = s.trim().split(" ", 2);
            if (split.length != 2) continue;
            switch (split[1]) {
                case "connections established": {
                    connectionsEstablished = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "active connection openings": {
                    connectionsActive = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "passive connection openings": {
                    connectionsPassive = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "failed connection attempts": {
                    connectionFailures = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "connection resets received": {
                    connectionsReset = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "segments sent out": {
                    segmentsSent = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "segments received": {
                    segmentsReceived = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "segments retransmitted": {
                    segmentsRetransmitted = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "bad segments received": {
                    inErrors = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "resets sent": {
                    outResets = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
            }
        }
        return new InternetProtocolStats.TcpStats(connectionsEstablished, connectionsActive, connectionsPassive, connectionFailures, connectionsReset, segmentsSent, segmentsReceived, segmentsRetransmitted, inErrors, outResets);
    }

    private static InternetProtocolStats.UdpStats getUdpStats(String netstatStr) {
        long datagramsSent = 0L;
        long datagramsReceived = 0L;
        long datagramsNoPort = 0L;
        long datagramsReceivedErrors = 0L;
        List<String> netstat = Executor.runNative(netstatStr);
        for (String s : netstat) {
            String[] split = s.trim().split(" ", 2);
            if (split.length != 2) continue;
            switch (split[1]) {
                case "packets sent": {
                    datagramsSent = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "packets received": {
                    datagramsReceived = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "packets to unknown port received": {
                    datagramsNoPort = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "packet receive errors": {
                    datagramsReceivedErrors = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
            }
        }
        return new InternetProtocolStats.UdpStats(datagramsSent, datagramsReceived, datagramsNoPort, datagramsReceivedErrors);
    }

    @Override
    public InternetProtocolStats.TcpStats getTCPv4Stats() {
        return LinuxInternetProtocolStats.getTcpStats("netstat -st4");
    }

    @Override
    public InternetProtocolStats.TcpStats getTCPv6Stats() {
        return new InternetProtocolStats.TcpStats(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv4Stats() {
        return LinuxInternetProtocolStats.getUdpStats("netstat -su4");
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv6Stats() {
        return LinuxInternetProtocolStats.getUdpStats("netstat -su6");
    }
}

