/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.software;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Executor;

public class LinuxUserGroupInfo {
    private final Map<String, Pair<String, String>> usersIdMap = LinuxUserGroupInfo.getUserMap();
    private final Map<String, String> groupsIdMap = LinuxUserGroupInfo.getGroupMap();

    private static Map<String, Pair<String, String>> getUserMap() {
        HashMap<String, Pair<String, String>> userMap = new HashMap<String, Pair<String, String>>();
        List<String> passwd = Executor.runNative("getent passwd");
        for (String entry : passwd) {
            String[] split = entry.split(":");
            if (split.length < 3) continue;
            String userName = split[0];
            String uid = split[2];
            userMap.putIfAbsent(uid, Pair.of(uid, userName));
        }
        return userMap;
    }

    private static Map<String, String> getGroupMap() {
        HashMap<String, String> groupMap = new HashMap<String, String>();
        List<String> group = Executor.runNative("getent group");
        for (String entry : group) {
            String[] split = entry.split(":");
            if (split.length <= 2) continue;
            String groupName = split[0];
            String gid = split[2];
            groupMap.putIfAbsent(gid, groupName);
        }
        return groupMap;
    }

    public Pair<String, String> getUser(String userId) {
        return this.usersIdMap.getOrDefault(userId, Pair.of(userId, "unknown"));
    }

    public String getGroupName(String groupId) {
        return this.groupsIdMap.getOrDefault(groupId, "unknown");
    }
}

