/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.software;

import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.software.InternetProtocolStats;
import org.aoju.bus.health.unix.CLibrary;
import org.aoju.bus.health.unix.freebsd.BsdSysctl;

@ThreadSafe
public class FreeBsdInternetProtocolStats
implements InternetProtocolStats {
    private Supplier<Pair<Long, Long>> establishedv4v6 = Memoize.memoize(FreeBsdInternetProtocolStats::queryTcpnetstat, Memoize.defaultExpiration());
    private Supplier<CLibrary.Tcpstat> tcpstat = Memoize.memoize(FreeBsdInternetProtocolStats::queryTcpstat, Memoize.defaultExpiration());
    private Supplier<CLibrary.Udpstat> udpstat = Memoize.memoize(FreeBsdInternetProtocolStats::queryUdpstat, Memoize.defaultExpiration());

    private static CLibrary.Tcpstat queryTcpstat() {
        CLibrary.Tcpstat tcpstat = new CLibrary.Tcpstat();
        BsdSysctl.sysctl("net.inet.tcp.stats", tcpstat);
        return tcpstat;
    }

    private static CLibrary.Udpstat queryUdpstat() {
        CLibrary.Udpstat udpstat = new CLibrary.Udpstat();
        BsdSysctl.sysctl("net.inet.udp.stats", udpstat);
        return udpstat;
    }

    private static Pair<Long, Long> queryTcpnetstat() {
        long tcp4 = 0L;
        long tcp6 = 0L;
        List<String> activeConns = Executor.runNative("netstat -n -p tcp");
        for (String s : activeConns) {
            if (!s.endsWith("ESTABLISHED")) continue;
            if (s.startsWith("tcp4")) {
                ++tcp4;
                continue;
            }
            if (!s.startsWith("tcp6")) continue;
            ++tcp6;
        }
        return Pair.of(tcp4, tcp6);
    }

    @Override
    public InternetProtocolStats.TcpStats getTCPv4Stats() {
        CLibrary.Tcpstat tcp = this.tcpstat.get();
        return new InternetProtocolStats.TcpStats(this.establishedv4v6.get().getLeft(), Builder.unsignedIntToLong(tcp.tcps_connattempt), Builder.unsignedIntToLong(tcp.tcps_accepts), Builder.unsignedIntToLong(tcp.tcps_conndrops), Builder.unsignedIntToLong(tcp.tcps_drops), Builder.unsignedIntToLong(tcp.tcps_snd_swcsum - tcp.tcps_sndrexmitpack), Builder.unsignedIntToLong(tcp.tcps_rcv_swcsum), Builder.unsignedIntToLong(tcp.tcps_sndrexmitpack), Builder.unsignedIntToLong(tcp.tcps_rcvbadsum + tcp.tcps_rcvbadoff + tcp.tcps_rcvmemdrop + tcp.tcps_rcvshort), 0L);
    }

    @Override
    public InternetProtocolStats.TcpStats getTCPv6Stats() {
        return new InternetProtocolStats.TcpStats(this.establishedv4v6.get().getRight(), 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv4Stats() {
        CLibrary.Udpstat stat = this.udpstat.get();
        return new InternetProtocolStats.UdpStats(Builder.unsignedIntToLong(stat.udps_snd_swcsum), Builder.unsignedIntToLong(stat.udps_rcv_swcsum), Builder.unsignedIntToLong(stat.udps_noportmcast), Builder.unsignedIntToLong(stat.udps_hdrops + stat.udps_badsum + stat.udps_badlen));
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv6Stats() {
        CLibrary.Udpstat stat = this.udpstat.get();
        return new InternetProtocolStats.UdpStats(Builder.unsignedIntToLong(stat.udps_snd6_swcsum), Builder.unsignedIntToLong(stat.udps_rcv6_swcsum), 0L, 0L);
    }
}

